﻿/**
 * Maths.as:	Funciones matematicas varias.
 * Created:		23/May/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1
 */

package utils {

	import flash.display.MovieClip;
	import flash.geom.Point;
	
	public class Maths {
		
		// Pasa de entero a cadena, parchando con ceros a la izquierda para que quede de tamaño "w"
		static public function intToPaddedString(num:int, w:int):String {
			var temp:String = num.toString();
			for (var i:int= temp.length; i< w; ++i) {
				temp = "0" + temp;
			}
			return(temp);
		}
		
		// Obtiene la distancia entre dos puntos
		static public function distance(ax:Number, ay:Number, bx:Number, by:Number):Number {
			var dX:Number= ax -bx;
			var dY:Number= ay -by;
			return(Math.sqrt(dX*dX + dY*dY));
		}
		
		// Obtiene el cuadrado de la distancia entre dos puntos
		static public function sqrDistance(ax:Number, ay:Number, bx:Number, by:Number):Number {
			var dX:Number= ax -bx;
			var dY:Number= ay -by;
			return(dX*dX + dY*dY);
		}
		
		// Obtiene la distancia entre dos puntos
		static public function pointDistance(a:Point, b:Point):Number {
			var dX:Number= a.x -b.x;
			var dY:Number= a.y -b.y;
			return(Math.sqrt(dX*dX + dY*dY));
		}
		
		// Obtiene el cuadrado de la distancia entre dos puntos
		static public function pointSqrDistance(a:Point, b:Point):Number {
			var dX:Number= a.x -b.x;
			var dY:Number= a.y -b.y;
			return(dX*dX + dY*dY);
		}
		
		// Obtiene la distancia entre dos MovieClips
		static public function clipDistance(a:MovieClip, b:MovieClip):Number {
			var dX:Number= a.x -b.x;
			var dY:Number= a.y -b.y;
			return(Math.sqrt(dX*dX + dY*dY));
		}
		
		// Obtiene el cuadrado de la distancia entre dos MovieClips
		static public function clipSqrDistance(a:MovieClip, b:MovieClip):Number {
			var dX:Number= a.x -b.x;
			var dY:Number= a.y -b.y;
			return(dX*dX + dY*dY);
		}
		
		// Obtiene el angulo de un vector en grados
		static public function vectorAngleDeg(dX:Number, dY:Number): Number {
			var angle:Number = Math.atan2(dY, dX);
			return(angle*180/Math.PI + 90);
		}
		
		// Ajusta el angulo para que esté entre -180° y 180°
		static public function canonicalAngleDeg(angle:Number): Number {
			while (angle <= -180) {
				angle+= 360;
			}
			while (angle >  180) {
				angle-= 360;
			}
			return(angle);
		}
		
	}
}