﻿/**
 * Input.as:	Para saber que teclas están presionadas (basado en un codigo por senocular).
 * Created:		20/Sep/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1
 */

package utils {

	import flash.display.Stage;
    import flash.events.Event;
    import flash.events.KeyboardEvent;

	public class Input {
		// Constantes de la clase
		public static const NUM_0:int = 48;						// Numeros del 0 al 9
		public static const NUM_1:int = 49;
		public static const NUM_2:int = 50;
		public static const NUM_3:int = 51;
		public static const NUM_4:int = 52;
		public static const NUM_5:int = 53;
		public static const NUM_6:int = 54;
		public static const NUM_7:int = 55;
		public static const NUM_8:int = 56;
		public static const NUM_9:int = 57;
		public static const A:int = 65;							// Letras
		public static const B:int = 66;
		public static const C:int = 67;
		public static const D:int = 68;
		public static const E:int = 69;
		public static const F:int = 70;
		public static const G:int = 71;
		public static const H:int = 72;
		public static const I:int = 73;
		public static const J:int = 74;
		public static const K:int = 75;
		public static const L:int = 76;
		public static const M:int = 77;
		public static const N:int = 78;
		public static const O:int = 79;
		public static const P:int = 80;
		public static const Q:int = 81;
		public static const R:int = 82;
		public static const S:int = 83;
		public static const T:int = 84;
		public static const U:int = 85;
		public static const V:int = 86;
		public static const W:int = 87;
		public static const X:int = 88;
		public static const Y:int = 89;
		public static const Z:int = 90;
		public static const PAD_0:int = 96;						// Teclado numérico
		public static const PAD_1:int = 97;
		public static const PAD_2:int = 98;
		public static const PAD_3:int = 99;
		public static const PAD_4:int = 100;
		public static const PAD_5:int = 101;
		public static const PAD_6:int = 102;
		public static const PAD_7:int = 103;
		public static const PAD_8:int = 104;
		public static const PAD_9:int = 105;
		public static const PAD_MULTIPLY:int = 106;
		public static const PAD_ADD:int 	 = 107;
		public static const PAD_ENTER:int 	 = 13;
		public static const PAD_SUBSTRACT:int= 109;
		public static const PAD_DECIMAL:int  = 110;
		public static const PAD_DIVIDE:int 	 = 111;	
		public static const F1:int = 112;						// Teclas de funcion (F10 no existe)
		public static const F2:int = 113;
		public static const F3:int = 114;
		public static const F4:int = 115;
		public static const F5:int = 116;
		public static const F6:int = 117;
		public static const F7:int = 118;
		public static const F8:int = 119;
		public static const F9:int = 120;
		public static const F11:int = 122;
		public static const F12:int = 123;
		public static const F13:int = 124;
		public static const F14:int = 125;
		public static const F15:int = 126;
		public static const BACKSPACE:int = 8;					// Otras teclas (incompleto)
		public static const TAB:int       = 9;
		public static const ENTER:int     = 13;
		public static const SHIFT:int     = 16;
		public static const CONTROL:int   = 17;
		public static const PAUSE:int     = 19;
		public static const CAPS_LOCK:int = 20;
		public static const ESC:int       = 27;
		public static const SPACE:int     = 32;
		public static const PAGE_UP:int   = 33;
		public static const PAGE_DOWN:int = 34;
		public static const END:int       = 35;
		public static const HOME:int      = 36;
		public static const LEFT:int      = 37;
		public static const UP:int        = 38;
		public static const RIGHT:int     = 39;
		public static const DOWN:int      = 40;
		public static const INSERT:int    = 45;
		public static const DELETE:int    = 46;
		public static const NUM_LOCK:int  = 144;
		public static const SCR_LK:int    = 145;
		private static const LAST_KEY:int = SCR_LK;				// Para saber cual es la última tecla en nuestro arreglo
		//Variables de la clase
		private static var initialized:Boolean = false;  		// Para saber si ya inicializamos la clase
        private static var keysDown:Array = new Array();  		// Para guardar si una tecla está siendo presionada
		
        
        /**
         * Inicializamos la clase
         */
        public static function initialize(stage:Stage) {
            if (!initialized) {
				// La marcamos como inicializada
				initialized = true;
                // Agregamos los eventos de las teclas
                stage.addEventListener(KeyboardEvent.KEY_DOWN, keyPressed, false, 0, true);
                stage.addEventListener(KeyboardEvent.KEY_UP, keyReleased, false, 0, true);
                stage.addEventListener(Event.DEACTIVATE, deactivate, false, 0, true);
				//
				clearKeys();
            }
        }

        /**
         * Regresa si una tecla esta siendo presionada
         */
        public static function isDown(code:uint):Boolean {
			// Si no está inicializado, mandamos un error
            if (!initialized) {
                throw new Error("Key class has not been initialized.");
            }
			// Regresamos si está siendo presionada la tecla
            return (keysDown[code]);
        }
		
		/**
		 * Marcamos todas la teclas como no presionadas
		 */
		private static function clearKeys():void {
            for (var i:int = 0; i< LAST_KEY; ++i) {
				keysDown[i] = false;
			}
        }
        
        /**
         * Para saber cuando una tecla se presionó
         */
        private static function keyPressed(e:KeyboardEvent):void {
            keysDown[e.keyCode] = true;
        }
        
        /**
         * Para saber cuando una tecla se soltó
         */
        private static function keyReleased(e:KeyboardEvent):void {
			keysDown[e.keyCode] = false;
        }

        /**
         * Si Flash ha sido desactivado (no está "enfocado")
         */
        private static function deactivate(event:Event):void {
			// Flash no puede saber cuales teclas están siendo presionadas, por lo que limpiamos todo
            clearKeys();
        }
    }
}