﻿/**
 * Database.as:	Guarda/carga los datos del jugador.
 * Created:		23/Aug/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1
 */

package utils {
	
	import flash.net.SharedObject;
	import flash.net.registerClassAlias;

	public class Database {
		public static const FILE:String = "FactoryGame"; 
		//Variables de la clase
		public static var playedBefore:Boolean;
		public static var highScore:HighscoreData;
		public static var sharedObj:SharedObject;		// Con lo que abrimos/guardamos datos

		public function Database() {
		}
		
		/**
		 * Cargamos los datos
		 */
		static public function loadData() {
			// Registramos nuestros objetos
			registerClassAlias("HighscoreData", HighscoreData);
			// Abrimos los datos locales
			try {
				sharedObj = SharedObject.getLocal(FILE);				
			} catch (error:Error) {
				trace("SharedObject Error:" + error.toString());
				return;
			}
			// 
			// Los asignamos a las variables
			playedBefore = true;
			highScore = sharedObj.data.highscores;			
			if (highScore == null) {
				playedBefore = false;
				highScore = new HighscoreData();
			}
		}

		/**
		 * Guardamos los datos
		 */
		static public function saveData() {
			// Pasamos los datos a objeto compartido
			sharedObj.data.highscores = highScore;
			// Guardamos datos locales
			sharedObj.flush();
		}
		
		/**
		 * Borramos los datos
		 */
		 static public function eraseData() {
			 sharedObj.clear();		
		 }
	}
}