﻿/**
 * MainMenu.as:	Menu del juego.
 * Created:		10/Ago/2008
 * 
 * author:		Pier Paolo Guillen Hernandez
 * version:		0.1
 */

package sections {

	import utils.Database;
	import mochi.MochiScores;
	import flash.display.MovieClip;
	import flash.display.SimpleButton;
	import flash.events.MouseEvent;
	
	public dynamic class MainMenu extends Section {
		/**
		 * Funcion para inicializar (constructor)
		 */
		public function MainMenu() {
			// 'Boton' de Instrucciones
			instructButton.stop();
			instructButton.addEventListener(MouseEvent.ROLL_OVER, instructOver, false, 0, true);
			instructButton.addEventListener(MouseEvent.ROLL_OUT, instructOut, false, 0, true);
			// 'Boton' de Highscore
			setHighScoreLabels();
			highscoreButton.hsData.visible = false;
			highscoreButton.stop();
			highscoreButton.addEventListener(MouseEvent.ROLL_OVER, highScoreOver, false, 0, true);
			highscoreButton.addEventListener(MouseEvent.ROLL_OUT, highScoreOut, false, 0, true);
			highscoreButton.hsData.globalScores.addEventListener(MouseEvent.MOUSE_DOWN, viewScoreTable, false, 0, true);
			// 'Boton' de Creditos
			creditsButton.stop();
			creditsButton.addEventListener(MouseEvent.ROLL_OVER, creditsOver, false, 0, true);
			creditsButton.addEventListener(MouseEvent.ROLL_OUT, creditsOut, false, 0, true);
			// Boton para empezar			
			startButton.addEventListener(MouseEvent.MOUSE_DOWN, startDown, false, 0, true);
		}
		
		/**
		 * Ponemos los textos del score más alto
		 */
		private function setHighScoreLabels():void {
			highscoreButton.hsData.nameLabel.text = Database.highScore.playerName;
			if (Database.playedBefore) {
				highscoreButton.hsData.scoreLabel.text = "Score: " + Database.highScore.score.toString();
				highscoreButton.hsData.lvlLabel.text = "Level: " + Database.highScore.level.toString();
				highscoreButton.hsData.comboLabel.text = "Max Combo: " + Database.highScore.maxCombo.toString();
				highscoreButton.hsData.timeLabel.text = "Played Time: " + Database.highScore.time;
				highscoreButton.hsData.dateLabel.text = "Date: " + Database.highScore.date;
			} else {
				highscoreButton.hsData.scoreLabel.text = "";
				highscoreButton.hsData.lvlLabel.text = "";
				highscoreButton.hsData.comboLabel.text = "";
				highscoreButton.hsData.timeLabel.text = "";
				highscoreButton.hsData.dateLabel.text = "";
			}
		}
		
		/**
		 * Vamos a la pantalla de seleccion de escena para empezar
		 */
		private function startDown(e:MouseEvent):void {
			finish = true;
			nextSect = new GameScreen();
		}

		/**
		 * Para emular el funcionamiento de un botón para la instrucciones
		 */		
		private function instructOver(e:MouseEvent):void {
			instructButton.gotoAndStop(2);
		}
		private function instructOut(e:MouseEvent):void {
			instructButton.gotoAndStop(1);
		}

		/**
		 * Para emular el funcionamiento de un botón con los 'Highscores'
		 */		
		private function highScoreOver(e:MouseEvent):void {
			highscoreButton.hsData.visible = true;
			highscoreButton.gotoAndStop(2);
		}
		private function highScoreOut(e:MouseEvent):void {
			highscoreButton.hsData.visible = false;
			highscoreButton.gotoAndStop(1);
		}

		/**
		 * Para emular el funcionamiento de un botón para los créditos
		 */		
		private function creditsOver(e:MouseEvent):void {
			creditsButton.gotoAndStop(2);
		}
		private function creditsOut(e:MouseEvent):void {
			creditsButton.gotoAndStop(1);
		}
		
		/**
		 * Abrimos la ventana con los scores
		 */
		private function viewScoreTable(e:MouseEvent):void {
			MochiScores.showLeaderboard({boardID: "414bcaece6221742"});
		}
	}
}