﻿/**
 * Game.as:		Parte principal del juego.
 * Created:		06/Ago/2008
 * 
 * author:		Pier Paolo Guillen Hernandez
 * version:		0.1
 */

package sections {

	import level.Ball;
	import level.FlyingText;
	import level.GearParticle;
	import level.DivisionParticle;
	import level.CollListener;
	import utils.Database;
	import utils.Input;
	import utils.Maths;
	import mochi.MochiScores;
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import flash.display.MovieClip;
	import flash.display.SimpleButton;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.Mouse;

	public dynamic class GameScreen extends Section {
		// Constantes de la clase
		private static const NUM_LVL_CHANGE:int = 5;		// Cada cuantos niveles hay cambios
		private static const LVL_CHANGE_START:int = 2;		// A partir de que nivel empiezan los cambios
		private static const ENERGY_INC:int = 10;			// Cantidad de incremento de energia
		private static const INITIAL_ENERGY:int = 100;		// Energia inicial
		private static const BALL_TIME:Number = 3.20;		// Tiempo entre cada pelota que cae
		private static const GEAR_LAYER_TRANS_SPEED = 0.2;	//
		private static const GRAVITY:b2Vec2 = new b2Vec2 (0.0, 9.0);
		private static const DO_SLEEP:Boolean = true;
		private static const BOX2D_ITERATIONS:int = 1;
		private static const SCORE_MULTIPLIER:int = 5;		// Por cuanto se multiplican los numeros al pasar al score
		private static const ENERGY_WARNING:int = 25;		//
		private static const RED_INC:int = 0x000606;		// Incremento para el color rojo de la energía
		// Variables de la instancia
		private var level:int;						// Nivel actual
		private var score:int;						// Puntos del jugador
		private var combo:int;
		private var maxCombo:int;
		private var energy:int;						// Energía del jugador
		private var currPrime:int;					// El primo actual (se utiliza para saber cuanto puntos se necesitan por nivel)
		private var levelScore:int;					// Puntos del jugador en el nivel actual
		private var nextLevelScore:int;				// Puntos para pasar el siguiente nivel
		private var time:Number;					// Tiempo jugado
		private var timeForBall:Number;				// Tiempo para la siguiente pelota
		private var timeRunning:Boolean;			// Para saber si el tiempo está corriendo o no
		private var energyTextFormat:TextFormat;
		private var sndLowEnergy:Sound;				//
		private var sndLoseLife:Sound;				// 
		private var sndNextLevel:Sound;				// 
		private var song:Sound;						// 
		private var sndTrans:SoundTransform;
		private var sngChannel:SoundChannel;		// 
		private var loseChannel:SoundChannel;		// 
		private var pausePosition:int;				// 
		private var pauseScreen:PauseScreen;		// 
		private var gameOverScreen:GameOverScreen;	// 
		private var muted:Boolean;					// 
		private var currGearLayer:MovieClip;		// 
		private var gameState:GameStateEnum;		// Estado actual
		private var wallBody:b2Body;
		private var wallBodyDef:b2BodyDef;
		private var leftWallDef:b2PolygonDef;
		private var rightWallDef:b2PolygonDef;
		private var topWallDef:b2PolygonDef;
		public var world:b2World;

		/**
    	 * Funcion para inicializar (constructor)
		 */
		public function GameScreen() {
			reset();
			Mouse.hide();
			paddle.x = mouseX;
			addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown, false, 0, true);
			addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove, false, 0, true);
			Main.currStage.addEventListener(KeyboardEvent.KEY_DOWN, keyPressed, false, 0, true);
		}

		/**
    	 * Getters
		 */
		public function get getLevel():Number {
			return (level);
		}
		public function get getLvlChange():Number {
			return (NUM_LVL_CHANGE);
		}
		public function get getState():GameStateEnum {
			return (gameState);
		}

		/**
    	 * Asignamos valores iniciales
		 */
		override public function reset():void {
			level = 1;
			score = 0;
			time = 0.0;
			combo = 0;
			maxCombo = 0;
			energy = INITIAL_ENERGY;
			currPrime = 101;
			levelScore = 0;			
			nextLevelScore = currPrime;			
			timeRunning = true;
			timeForBall = 0;
			muted= false;			
			gameState = GameStateEnum.PLAY
			energyTextFormat = new TextFormat();
			// Valores de las capas del fondo
			currGearLayer = null;
			gearsLayer1.alpha = 0.0;
			gearsLayer2.alpha = 0.0;
			gearsLayer3.alpha = 0.0;
			gearsLayer4.alpha = 0.0;
			gearsLayer1.visible = false;
			gearsLayer2.visible = false;
			gearsLayer3.visible = false;
			gearsLayer4.visible = false;
			// Valores del sonido
			song = new DecemberDance();
			sndNextLevel = new NextLevel();
			sndLoseLife = new LoseLife();
			sndLowEnergy = new LowEnergy();
			sndTrans = new SoundTransform();
			sngChannel = song.play();
			sngChannel.addEventListener(Event.SOUND_COMPLETE, loopMusic, false, 0, true);
			// Botones
			playBtn.visible = false;
			playBtn.enabled = false;
			unmuteBtn.visible = false;
			unmuteBtn.enabled = false;
			// Datos de las pantallas adicionales
			pauseScreen = new PauseScreen();
			gameOverScreen = new GameOverScreen();
			gameOverScreen.infoText.submitButton.addEventListener(MouseEvent.MOUSE_DOWN, submitDown, false, 0, true);
			gameOverScreen.infoText.retryButton.addEventListener(MouseEvent.MOUSE_DOWN, retryDown, false, 0, true);
			gameOverScreen.infoText.menuButton.addEventListener(MouseEvent.MOUSE_DOWN, menuDown, false, 0, true);
			// Valores de la libreria de física
			//Creamos el mundo
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set(-50, -50);
			worldAABB.upperBound.Set( 50,  50);
			world = new b2World(worldAABB, GRAVITY, DO_SLEEP);
			// Ponemos las paredes
			wallBodyDef = new b2BodyDef();		
			topWallDef = new b2PolygonDef();
			topWallDef.friction = 0;
			topWallDef.SetAsOrientedBox(20/3, 5, new b2Vec2 (20/3, -5), 0);
			leftWallDef = new b2PolygonDef();
			leftWallDef.friction = 0;
			leftWallDef.SetAsOrientedBox(5, 25/3 + 10, new b2Vec2 (-5, 25/3), 0);
			rightWallDef = new b2PolygonDef();
			rightWallDef.friction = 0;
			rightWallDef.SetAsOrientedBox(5, 25/3 + 10, new b2Vec2 (40/3 + 5, 25/3), 0);
			wallBody = world.CreateBody(wallBodyDef);
			wallBody.CreateShape(topWallDef );
			wallBody.CreateShape(leftWallDef);
			wallBody.CreateShape(rightWallDef);
			//
			world.SetContactListener(new CollListener());
			// Reseteamos al paddle (tiene que ser despues de crear al mundo, ya que lo utiliza el paddle)
			Paddle.currPaddle.reset(this);
		}
		
		/**
		 *
		 */
		public function cleanup():void {
			energyTextFormat = null;
			song = null;
			sndNextLevel = null;
			sndLoseLife = null;
			sndLowEnergy = null;
			sndTrans = null;
			sngChannel.stop();
			loseChannel.stop();
			sngChannel = null;
			loseChannel = null;
			removeChild(gameOverScreen);
		}

		/**
    	 * Actualizamos los elementos
		 */
		override public function update(dT:Number):void {
			if (gameState == GameStateEnum.PLAY) {
				// Incrementamos el tiempo
				if (timeRunning) {
					time += dT;
				}
				// Vemos si soltamos mas pelotas
				timeForBall-= dT;
				if (timeForBall <= 0) {
					addChild(new Ball(this));
					timeForBall = BALL_TIME;
				}
				// Actualizamos la etiquieta de energia extra
				extraEnergy.update();
				// Vemos si incrementamos de nivel
				if (levelScore >= nextLevelScore) {
					levelScore-= nextLevelScore;
					nextLevelScore+= nextPrime();
         			++level;
					// Agregamos energia
					energy+= ENERGY_INC;
					extraEnergy.gotoAndPlay(1);
					// Cambios al llegar a determinado nival
					switch (level) {
						case LVL_CHANGE_START:
							currGearLayer = gearsLayer1;
							gearsLayer1.visible = true;
							break;
						case LVL_CHANGE_START + NUM_LVL_CHANGE:
							currGearLayer = gearsLayer2;
							gearsLayer2.visible = true;
							break;
						case LVL_CHANGE_START + 2*NUM_LVL_CHANGE:
							currGearLayer = gearsLayer3;
							gearsLayer3.visible = true;
							break;
						case LVL_CHANGE_START + 3*NUM_LVL_CHANGE:
							currGearLayer = gearsLayer4;
							gearsLayer4.visible = true;
							break;
					}
					sndNextLevel.play();
				}
				// Actualizamos el fondo
				if ((currGearLayer != null) && (currGearLayer.alpha < 1)) {
					currGearLayer.alpha+= dT*GEAR_LAYER_TRANS_SPEED;
				}
				// Actualizamos los objetos en la libreria de fisica
				world.Step(dT, BOX2D_ITERATIONS);
				// Actualizamos las pelotas
				for (var i:int= 0; i< Ball.numBalls; ++i) {
					Ball.list[i].update(dT);
				}
				// Actualizamos el paddle
				paddle.update(dT);				
				// Actualizamos las particulas
				for (i = 0; i< GearParticle.numParticles; ++i) {
					GearParticle.list[i].update(dT);
				}
				for (i = 0; i< DivisionParticle.numParticles; ++i) {
					DivisionParticle.list[i].update(dT);
				}
				for (i = 0; i< FlyingText.numParticles; ++i) {
					FlyingText.list[i].update(dT);
				}	
				// Actualizamos la barra
				expBar.width = emptyBar.width*(levelScore/nextLevelScore);
				// Actualizamos los textos
				levelLabel.text = level.toString();
				energyLabel.text = energy.toString();
				scoreLabel.text = score.toString()
				if (energy <= ENERGY_WARNING) {
					var temp:int = (0xA0*energy)/ENERGY_WARNING;
					energyTextFormat.color = 0xFF3030 + 0x0101*temp;
				} else {
					energyTextFormat.color = 0xC1E4C9;
				}
				energyLabel.setTextFormat(energyTextFormat);  
				// Revisamos si perdió
				if (energy <= 0) {
					// Si perdió ponemos la pantalla de "Game Over!"
					gameState = GameStateEnum.GAME_OVER;					
					Mouse.show();
					loseChannel = sndLoseLife.play();
					loseChannel.addEventListener(Event.SOUND_COMPLETE, showFinalScore, false, 0, true);
					sngChannel.stop();
					gameOverScreen.infoText.fnlScore.text = score.toString();
					gameOverScreen.infoText.visible = false;
					addChild(gameOverScreen);
				}
			} else if (gameState == GameStateEnum.GAME_OVER) {
				// Todo se hace arriba o en "showFinalScore"
			}
		}

		/**
		 * Revisa si se rompió el highscore anterior
		 */
		 public function checkHighScore():void {
			 Database.playedBefore = true;
			 if (score > Database.highScore.score) {
				Database.highScore.playerName = gameOverScreen.infoText.nameInputText.text;
				Database.highScore.score = score;
				Database.highScore.level = level;
				Database.highScore.maxCombo = maxCombo;
				var elapsedTime:int = int(time);
				var min:String = (int)(elapsedTime / 60).toString();
				var sec:String = Maths.intToPaddedString(elapsedTime % 60, 2);
				Database.highScore.time = min + ":" + sec;
				var date:Date = new Date();
				Database.highScore.date = date.toDateString();
				Database.saveData();
			 }
		 }

		/**
    	 * Busca el siguiente primo
		 */
		public function nextPrime(): int {
			do {
				currPrime+= 2;
			} while (!prime(currPrime));
			return(currPrime);
		}
		 
		/**
    	 * Revisa si un número impar es primo o no
		 */
		public function prime(num:int):Boolean {
			for (var i:int = 3; (i<= Math.sqrt(num)) && (num % i != 0); i+= 2);
			return (num % i != 0);
		}
		 
		/**
		 * Incrementa en 1 el combo
		 */
		public function incCombo():void {
			combo++;
			if (combo > maxCombo) {
				maxCombo = combo;
			}
			if (combo > 1) {
				var size:Number = 18 + combo/5;
				if (size > 28) {
					size = 28;
				}
				addChildAt(new FlyingText("x "+combo.toString(), size, paddle.x, paddle.y -25), numChildren -Ball.numBalls);
			}
		}
		
		/**
		 * Regresa el combo a cero
		 */
		public function clearCombo():void {
			combo= 0;
		}

		/**
    	 * Incrementa el score
		 */
		 public function incScore(amount:int): void {
			 score+= (amount*SCORE_MULTIPLIER) + combo;
			 levelScore+= (amount*SCORE_MULTIPLIER);
		 }

		/**
    	 * Decrementa la energia
		 */
		 public function decEnergy(amount:int): void {
			 if ((energy > ENERGY_WARNING) && (energy -amount <= ENERGY_WARNING) && (energy -amount > 0)) {
	             sndLowEnergy.play();
			 }
			 energy-= amount;
			 if (energy < 0) {
				 energy = 0;
			 }
		 }

		/**
		 * Para el score final
		 */
		protected function showFinalScore(e:Event) {
			gameOverScreen.infoText.visible = true;	
		}

		/**
    	 * Al mover el mouse
		 */
		protected function onMouseMove(e:MouseEvent):void {
			paddle.position = e.stageX;
			verLinePointer.x = e.stageX;
			horLinePointer.y = e.stageY;
			blockPointer.x =  e.stageX;
			blockPointer.y =  e.stageY;
		}

		/**
    	 * Al presionar el mouse
		 */
		protected function onMouseDown(e:MouseEvent):void {
			if (pauseBtn.inside) {
				pauseDown();
			} else if (qualityBtn.inside) {
				qualityDown();
			} else if ((muteBtn.inside) || (unmuteBtn.inside)) {
				muteDown();
			} else if (gameState == GameStateEnum.PLAY) {
				paddle.nextPaddlePrime();
			}
		}

		/**
         * Para saber cuando una tecla se presionó
         */
        private function keyPressed(e:KeyboardEvent):void {
			// Revisamos las teclas
			if ((e.keyCode == Input.P) || (e.keyCode == Input.ESC)) {
				// Tecla de pausa
				pauseDown();
			} else if (e.keyCode == Input.M) {
				// Tecla de 'mute'
				muteDown();
			} else if (e.keyCode == Input.Q) {
				// Tecla de 'quality'
				qualityDown();
			} else
			// Teclas para controlar los primos en el paddle
			if (e.keyCode == Input.NUM_1) {
				paddle.setPaddlePrime(0);
			} else if (e.keyCode == Input.NUM_2) {
				paddle.setPaddlePrime(1);
			} else if (e.keyCode == Input.NUM_3) {
				paddle.setPaddlePrime(2);
			} else if (e.keyCode == Input.NUM_4) {
				paddle.setPaddlePrime(3);
			} else if (e.keyCode == Input.LEFT) {
				paddle.prevPaddlePrime();
			} else if (e.keyCode == Input.RIGHT) {
				paddle.nextPaddlePrime();
			}
        }
		
		/**
		 * Para reiniciar la música cuando termine (pero no desde el principio)
		 */
		protected function loopMusic(e:Event) {
			sngChannel.removeEventListener(Event.SOUND_COMPLETE, loopMusic);			
			sngChannel = song.play(10892);
			sngChannel.addEventListener(Event.SOUND_COMPLETE, loopMusic, false, 0, true);			
		}
		
		/**
		 * Botones durante el juego
		 */
		private function pauseDown():void {
			if (gameState == GameStateEnum.PLAY) {
				gameState = GameStateEnum.PAUSE;
				timeRunning = false;
				playBtn.visible = true;
				playBtn.enabled = true;
				pauseBtn.visible = false;
				pauseBtn.enabled = false;
				pausePosition = sngChannel.position;
				sngChannel.stop();
				sngChannel.removeEventListener(Event.SOUND_COMPLETE, loopMusic);
				addChild(pauseScreen);
			} else if (gameState == GameStateEnum.PAUSE) {
				gameState = GameStateEnum.PLAY;
				timeRunning = true;
				playBtn.visible = false;
				playBtn.enabled = false;
				pauseBtn.visible = true;
				pauseBtn.enabled = true;
				sngChannel = song.play(pausePosition);
				sngChannel.addEventListener(Event.SOUND_COMPLETE, loopMusic, false, 0, true);
				removeChild(pauseScreen);
			}
		}
		private function muteDown():void {
			if (muted) {
				muted = false;
				muteBtn.visible = true;
				muteBtn.enabled = true;
				unmuteBtn.visible = false;
				unmuteBtn.enabled = false;
				sndTrans.volume = 1.0;
				SoundMixer.soundTransform = sndTrans;
			} else {
				muted = true;
				muteBtn.visible = false;
				muteBtn.enabled = false;
				unmuteBtn.visible = true;
				unmuteBtn.enabled = true;
				sndTrans.volume = 0.0;
				SoundMixer.soundTransform = sndTrans;
			}	
		}
		private function qualityDown():void {
			if (Main.currStage.quality == StageQuality.LOW.toUpperCase() ) {
				Main.currStage.quality = StageQuality.MEDIUM;
			} else if (Main.currStage.quality == StageQuality.MEDIUM.toUpperCase()) {
				Main.currStage.quality = StageQuality.HIGH;
			} else if (Main.currStage.quality == StageQuality.HIGH.toUpperCase()) {
				Main.currStage.quality = StageQuality.LOW;
			}
		}

		/**
		 * Botones de la pantalla de "Game Over"
		 */
		private function submitDown(e:MouseEvent):void {
			// Mandamos el score
			MochiScores.showLeaderboard({boardID: "414bcaece6221742", score: score, 
										name:gameOverScreen.infoText.nameInputText.text});
			// Vemos si rompe el score local
			checkHighScore();
			// Quitamos el botón de submit (para que el usuario no le pique varias veces)
			gameOverScreen.infoText.submitButton.visible = false;
		}
		private function retryDown(e:MouseEvent):void {
			cleanup();
			// Checamos si rompió el highscore (por si no lo mandó)
			checkHighScore();
			// Cerramos la tabla de scores (en caso de que esté abierta)
			MochiScores.closeLeaderboard();
			// Volvemos a comenzar
			finish = true;
			nextSect = new GameScreen();
		}
		private function menuDown(e:MouseEvent):void {
			cleanup();
			// Checamos si rompió el highscore (por si no lo mandó)
			checkHighScore();
			// Cerramos la tabla de scores (en caso de que esté abierta)
			MochiScores.closeLeaderboard();
			// Regresamos al menu
			finish = true;
			nextSect = new MainMenu();
		}
	}
}