﻿/**
 * Paddle.as:	En lo que van a rebotar los números.
 * Created:		08/Sep/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1   
 */

package level {

	import sections.GameScreen;
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import flash.display.MovieClip;
	import flash.text.TextField;

    public class Paddle extends MovieClip {
		// Constantes de la clase
		public static const primes:Array = [2, 3, 5, 7];
		public static const FRICTION = 0.1;
		// Variables de la clase
		public static var currPaddle:Paddle;		
		// Variables de la instancia
		protected var currPrime:int;
		protected var nextX:int;
		protected var screen:GameScreen;
		protected var body:b2Body;
		protected var bodyDef:b2BodyDef;
		protected var blockDef:b2PolygonDef;
		protected var leftEdgeDef:b2CircleDef;
		protected var rightEdgeDef:b2CircleDef;


        /**
		 * Funcion para inicializar (constructor)
		 */
        public function Paddle():void {			
			currPaddle = this;
        }
		
		/**
		 * Setters
		 */
		public function set position(nX:Number):void {
			nextX= nX;
		}
		
		/**
		 * Getters
		 */
		public function get prime():int {
			return (primes[currPrime]);
		}
		public function get primePos():int {
			return (currPrime);
		}

		/**
		 * Reinicia los valores principales
		 */
        public function reset(_screen:GameScreen):void {
			screen = _screen;
			gotoAndStop(1);
			currPrime = 0;			
			nextX = x;
			// Datos para las colisiones
			bodyDef = new b2BodyDef();
			bodyDef.position.Set(x/30, y/30);
			bodyDef.userData = this;
			blockDef = new b2PolygonDef();
			blockDef.friction = FRICTION;
			blockDef.SetAsBox(1.27, 0.32);
			leftEdgeDef = new b2CircleDef();
			leftEdgeDef.friction = FRICTION;
			leftEdgeDef.radius = 0.32;
			leftEdgeDef.localPosition.Set(-1.27, 0.0);
			rightEdgeDef = new b2CircleDef();
			rightEdgeDef.friction = FRICTION;
			rightEdgeDef.radius = 0.32
			rightEdgeDef.localPosition.Set(1.27, 0.0);
			body = screen.world.CreateBody(bodyDef);
			body.CreateShape(blockDef);
			body.CreateShape(leftEdgeDef);
			body.CreateShape(rightEdgeDef);
        }

		/**
		 * Actualizamos el paddle
		 */
        public function update(time:Number):void {
			x = nextX;
			body.SetXForm(new b2Vec2(x/30, y/30), 0);
		}
		
		/**
		 * Pasa al siguiente primo (de los que se pueden usar en el paddle)
		 */
		public function nextPaddlePrime():void {
			++currPrime;
			if (currPrime >= primes.length) {
				currPrime = 0;
			}
			gotoAndStop(currPrime + 1);
		}
		
		/**
		 * Pasa al primo anterior (de los que se pueden usar en el paddle)
		 */
		public function prevPaddlePrime():void {
			--currPrime;
			if (currPrime < 0) {
				currPrime = primes.length -1;
			}
			gotoAndStop(currPrime + 1);
		}
		
		/**
		 * Pone un primo es específico (de los que se pueden usar en el paddle)
		 */
		public function setPaddlePrime(pos:int):void {
			currPrime= pos;
			if (currPrime < 0) {
				currPrime = primes.length -1;
			}
			if (currPrime >= primes.length) {
				currPrime = 0;
			}
			gotoAndStop(currPrime + 1);
		}
    }
}