﻿/**
 * Particle.as:	Particulas que salen de los engranes cuando los dividen.
 * Created:		18/Sep/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1   
 */

package level {

	import flash.display.MovieClip;
	import flash.text.TextField;

    public class GearParticle extends MovieClip {
		// Constantes
		public static const MIN_SIZE:Number= 1.00;		    // 
		public static const VAR_SIZE:Number= 0.25;		    // 
		public static const INITIAL_LIFE:Number= 0.75;		// 
		public static const SPEED:Number= -25.0;			//
		// Variables de la clase
		public static var numParticles:int = 0;				// Cuantos particulas existen
		public static var list:Array = new Array();			// Arreglo en el que guardamos a todas las salidas
		// Variables
		protected var id:int;
		protected var life:Number;
		protected var velX:Number;
		protected var velY:Number;

        /**
		 * Funcion para inicializar (constructor)
		 */ 
        public function GearParticle(startX:int, startY:int, vX:Number, vY:Number):void {
			//
			x= startX;
			y= startY;
			var angle:Number = Math.atan2(vY, vX) + (Math.PI)*(Math.random() -0.5);
			velX = SPEED*Math.cos(angle);
			velY = SPEED*Math.sin(angle);
			//
			id = numParticles++;
			reset();			
			list.push(this);
        }

		/**
		 * Reinicia los valores principales 
		 */
		public function reset():void {
			// Vida inicial
			life = INITIAL_LIFE;
			// Tamaño inicial
			var scale:Number= VAR_SIZE*Math.random() + MIN_SIZE;
			scaleX= scale;
			scaleY= scale;
        }

		/**
		 * Actualizamos el estado
		 */
		public function update(time:Number):void {
			// Actualizamos posiciones
			x+= velX*time;
			y+= velY*time;
			// Decrece su tiempo de vida y lo desvanecemos
			life-= time;
			if (life > 0) {
				alpha= life/INITIAL_LIFE;
			} else {
				deleteParticle();
			}
        }

		/**
		 * Lo quitamos del arreglo y de la escena
		 */
		protected function deleteParticle():void {
			// Cambiamos al actual al final para después removerlo			
			list[numParticles -1].id = id;
			list[id] = list[numParticles -1];
			list.pop();
			parent.removeChild(this);
			--numParticles;
		}
    }
}
