﻿/**
 * PauseScree.as:		Contador de combo.
 * Created:		13/Abr/2009
 * 
 * author:		Pier Paolo Guillen Hernandez
 * version:		0.9
 */

package level {
	
	import flash.display.MovieClip;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class FlyingText extends MovieClip {
		// Constantes
		public static const INITIAL_LIFE:Number= 2.0;		// 
		public static const SPEED:Number= -60.0;			//
		// Variables de la clase
		public static var numParticles:int = 0;				// Cuantos particulas existen
		public static var list:Array = new Array();			// Arreglo en el que guardamos a todas las salidas
		// Variables
		protected var id:int;
		protected var life:Number;

		/**
    	 * Funcion para inicializar (constructor)
		 */
		public function FlyingText(_label:String, _size:Number, _xPos:Number, _yPos:Number) {
			x = _xPos;
			y = _yPos;
			life = INITIAL_LIFE;
			var myFormat:TextFormat = new TextFormat();
			myFormat.size = _size;
			comboLabel.text = _label;
			comboLabel.setTextFormat(myFormat);  
			//
			id = numParticles++;
			list.push(this);
		}
		
		/**
		 * Para actualizars
		 */
		public function update(time:Number):void {
			y+= SPEED*time;
			life-= time;
			if (life > 0) {
				alpha= life/INITIAL_LIFE;
			} else {
				deleteParticle();
			}
		}
		
		/**
		 * Lo quitamos del arreglo y de la escena
		 */
		protected function deleteParticle():void {
			// Cambiamos al actual al final para después removerlo			
			list[numParticles -1].id = id;
			list[id] = list[numParticles -1];
			list.pop();
			parent.removeChild(this);
			--numParticles;
		}
		
	}
	
}