﻿/**
 * Particle.as:	Particulas que salen de los engranes cuando los dividen.
 * Created:		18/Sep/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1   
 */

package level {

	import flash.display.MovieClip;
	import flash.text.TextField;

    public class DivisionParticle extends MovieClip {
		// Constantes
		public static const GRAVITY:Number = 150.00;		// Aceleracion de la gravedad
		public static const MAX_VEL_Y:Number = 500.0;		// Velocidad máxima en y
		public static const MIN_SIZE:Number= 1.00;		    // 
		public static const VAR_SIZE:Number= 0.25;		    // 
		public static const INITIAL_LIFE:Number= 1.5;		// 
		public static const INITIAL_VEL_X:Number= 150.0;	//
		public static const INITIAL_VEL_Y:Number= 350.0;	//
		// Variables de la clase
		public static var numParticles:int = 0;				// Cuantos salidas existen
		public static var list:Array = new Array();			// Arreglo en el que guardamos a todas las salidas
		// Variables
		protected var id:int;
		protected var life:Number;
		protected var velX:Number;
		protected var velY:Number;

        /**
		 * Funcion para inicializar (constructor)
		 */ 
        public function DivisionParticle(startX:int, startY:int, frame:int):void {
			//
			x= startX;
			y= startY;
			gotoAndStop(frame);
			//
			id = numParticles++;
			reset();			
			list.push(this);
        }

		/**
		 * Reinicia los valores principales de la nube
		 */
		public function reset():void {
			// Vida inicial
			life = INITIAL_LIFE;
			// Velocidad inicial
			velX= INITIAL_VEL_X*Math.random() -INITIAL_VEL_X/2;
			velY= -INITIAL_VEL_Y*Math.random() -INITIAL_VEL_Y/2;
			// Tamaño inicial
			var scale:Number= VAR_SIZE*Math.random() + MIN_SIZE;
			scaleX= scale;
			scaleY= scale;
        }

		/**
		 * Actualizamos el estado de la nube
		 */
		public function update(time:Number):void {
			// Actualizamos la velocidad
			velY+= GRAVITY*time;
			if (velY > MAX_VEL_Y) {
				velY = MAX_VEL_Y;
			}
			// Actualizamos posiciones
			x+= velX*time;
			y+= velY*time;
			// Decrece su tiempo de vida y lo desvanecemos
			life-= time;
			if (life > 0) {
				alpha= life/INITIAL_LIFE;
			} else {
				deleteParticle();
			}
        }

		/**
		 * Lo quitamos del arreglo y de la escena
		 */
		protected function deleteParticle():void {
			// Cambiamos al actual al final para después removerlo			
			list[numParticles -1].id = id;
			list[id] = list[numParticles -1];
			list.pop();
			parent.removeChild(this);
			--numParticles;
		}
    }
}
