﻿/**
 * CollListener.as:		Para manejar las acciones que deben suceder en las colisiones.
 * Created:		23/Sep/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1   
 */

package level {

	import level.Ball;
	import level.Paddle;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Dynamics.*;

	public class CollListener extends b2ContactListener {

		public override function Add(point:b2ContactPoint):void {
			// Si alguna pelota choco con el Paddle, lo reportamos para procesarlo después
			if ((point.shape1.GetBody().GetUserData() is Paddle) ||
				(point.shape2.GetBody().GetUserData() is Paddle)) {
				if (point.shape1.GetBody().GetUserData() is Ball) {
					point.shape1.GetBody().GetUserData().setPaddleColl = true;
				} else if (point.shape2.GetBody().GetUserData() is Ball) {
					point.shape2.GetBody().GetUserData().setPaddleColl = true;
				}
			}
      	}
  	}
}
