﻿/**
 * Ball.as:		Pelotas que caen y tiene que rebotar.
 * Created:		08/Sep/2008
 * 
 * author:		Pier Paolo Guillen Hernandez 
 * version:		0.1   
 */

package level {

	import sections.GameScreen;
	import utils.Maths;
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import flash.display.MovieClip;
	import flash.media.Sound;
	import flash.text.TextField;
	import flash.text.TextFormat;

    public class Ball extends MovieClip {
		// Constantes de la clase
		public static const START_X:Number = 400/(2*30);
		public static const MAX_VEL_X:Number = 4.0;	// Velocidad máxima en x
		public static const RES_COEF:Number = 0.85;		// Coeficiente de restitucion
		public static const GEAR_INIT_SIZE:Number = 60;
		public static const GEAR_SCALING:Number = 0.2;	// Con cada factor, el engrane crece un 20%
		public static const INIT_TIME_FOR_GEAR_PART:Number = 0.02;
		public static const PARTICLES_PER_COL:int = 5;
		// Variables de la clase
		public static var numBalls:int = 0;				// Cuantos pelotas existen
		public static var list:Array = new Array();		// Arreglo en el que guardamos a todas las pelotas
		// Variables de la instancia
		protected var id:int;
		protected var num:int;
		protected var screen:GameScreen;
		protected var format:TextFormat;
		protected var timeGearPart:Number;
		protected var paddleColl:Boolean;
		protected var divides:Sound = new PaddleDivide();
		protected var dontDivides:Sound = new PaddleDontDivide();
		protected var loseEnergy:Sound = new LoseEnergy();
		protected var body:b2Body;
		protected var bodyDef:b2BodyDef;
		protected var circle:b2CircleShape;
		protected var circleDef:b2CircleDef;


        /**
		 * Funcion para inicializar (constructor)
		 */
        public function Ball(_screen:GameScreen):void {
			id = numBalls++;
			reset(_screen);
			list.push(this);
        }

		/**
		 * Reinicia los valores principales
		 */
        public function reset(_screen:GameScreen):void {
			screen = _screen;
			paddleColl = false;
			timeGearPart= INIT_TIME_FOR_GEAR_PART;
			num = initialNumber();
			numLabel.text = num.toString();			
			// Numero en la pelota
			format = new TextFormat();
			format.bold = true;
			numLabel.setTextFormat(format);			
			// Datos para las colisiones
			bodyDef = new b2BodyDef();
			bodyDef.position.Set(START_X, 0);
			bodyDef.userData = this;
			circleDef = new b2CircleDef();
			circleDef.density = 1.0;
			circleDef.friction = 1.0;
			circleDef.restitution = RES_COEF;
			body = screen.world.CreateBody(bodyDef);
			circle = body.CreateShape(circleDef) as b2CircleShape;
			body.SetMassFromShapes();
			body.SetLinearVelocity(new b2Vec2 (2*MAX_VEL_X*Math.random() -MAX_VEL_X, 0.0));
			// Ponemos los valores del engrane que cambian durante el juego
			setGearValues();
        }
		
		/**
		 * Setters
		 */
		public function set setPaddleColl(coll:Boolean):void {
			paddleColl = coll;
		}

        /**
		 * Actualizamos la pelota
		 */
        public function update(time:Number):void {
			// Actualizamos posiciones
			x = 30*body.GetPosition().x;
			y = 30*body.GetPosition().y;
			gear.rotation+= 30*body.GetLinearVelocity().x*time;
			// Si ya está listo, soltamos particulas
			if (num == 1) {
				timeGearPart-= time;
				while (timeGearPart <= 0) {
					timeGearPart+= INIT_TIME_FOR_GEAR_PART;
					parent.addChildAt(
						new GearParticle(x, y, 30*body.GetLinearVelocity().x, 30*body.GetLinearVelocity().y), 
							parent.numChildren -numBalls);
				}
			}
			// Revisamos si chocó contra el paddle
			if (paddleColl) {
				collisionResponse();
				paddleColl = false;
			}
			// Revisamos si salió
			if (y > 500 + height/2) { 
				if (num != 1) {
					screen.clearCombo();
					loseEnergy.play();
				}
				for (var i:int = 0; i< Paddle.primes.length; ++i) {
					while (num % Paddle.primes[i] == 0) {
						num /= Paddle.primes[i];
						screen.decEnergy(Paddle.primes[i]);
					}
				}
				deleteBall();
				return;
			}
		}
		
		/**
		 * Como responde a la colision con el paddle
		 */
	 	private function collisionResponse():void {
			var paddle:Paddle = Paddle.currPaddle;
			// Vemos si tenemos que cambiar el número
			if (num % paddle.prime == 0) {
				num/= paddle.prime;
				numLabel.text = (num > 1 ) ? (num.toString()) : ("");
				numLabel.setTextFormat(format);
				if (num == 1) {
					screen.incCombo();
				}
				screen.incScore(paddle.prime);
				setGearValues();
				for (var i:int = 0; i< PARTICLES_PER_COL; ++i) {
					parent.addChildAt(new DivisionParticle(x, y, paddle.primePos + 1), parent.numChildren -numBalls);
				}
				divides.play();
			} else {
				dontDivides.play();
			}
		}

		/**
		 * El número con el que va a empezar la pelota
		 */
		private function initialNumber():int {
			var factors:int = (screen.getLevel / screen.getLvlChange) + 1;
			var number:int = 1;
			for (var i:int = 0; i< factors; ++i) {
				var pos:int = Paddle.primes.length*Math.random();
				number*= Paddle.primes[pos];
			}
			return (number);
		}

		/**
		 * Pone los valores que le corresponden al engrane
		 */
		private function setGearValues():void {
			// Ponemos el color
			var temp:int = num;
			var colour:int = 0;
			var factors:Number = 0;
			for (var i:int = 0; i< Paddle.primes.length; ++i) {
				while (temp % Paddle.primes[i] == 0) {
					++factors;
					colour|= 1 << i;
					temp/= Paddle.primes[i];
				}
			}
			gear.gotoAndStop(colour + 1);
			// Ponemos el tamaño
			gear.scaleX = gear.scaleY = 1 + GEAR_SCALING*factors;
			// Reescalamos la colision
			circle.m_radius = (0.8*width)/(2*30);
		}

		/**
		 * Lo quitamos del arreglo y de la escena
		 */
		protected function deleteBall():void {
			// Cambiamos al actual al final para después removerlo			
			list[numBalls -1].id = id;
			list[id] = list[numBalls -1];
			list.pop();
			screen.world.DestroyBody(body);
			parent.removeChild(this);
			--numBalls
		}
		
		/**
		 * Quitamos las pelotas
		 */
		public static function clearBalls():void {
			numBalls = 0;
			list = new Array();
		}
    }
}