﻿/**
 * Main.as:		Archivo principal, tiene la clase que será asignada al documento fla.
 * Created:		13/May/2008
 * 
 * author:		Pier Paolo Guillen Hernandez
 * version:		0.1
 */

package {

	import sections.*;
	import utils.Database;
	import mochi.MochiBot;
	import mochi.MochiServices;
	import flash.display.MovieClip;
	import flash.display.Stage;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.utils.getTimer;

	public dynamic class Main extends MovieClip {
		// Variables de la clase
		public static var pointerX:Number = 0;
		public static var pointerY:Number = 0;
		public static var currStage:Stage = null;
		// Variables
		private var time:int;
		private var nextSect:Section;
		private var currSect:Section;
		private var validated:Boolean;
		public var _mochiads_game_id:String = "9b9c496231481c42";		// Para MochiAds
		//
		private const allowedSite:Array = ["pier.guillen.com.mx", "www.guillen.com.mx", "www.flashgamelicense.com", "games.mochiads.com"];

		/**
		 * Funcion para inicializar (constructor)
		 */
		public function Main() {
			// Para mandar los datos al Mochibot y Mochiads
			MochiBot.track(this, "3d3c8689");
			MochiServices.connect(_mochiads_game_id, this);
			// Por el control de version de MochiAds, puede que la escena todavía no esté en el 'stage'
			if (stage != null) {
				initStage(null);
			} else {
				addEventListener(Event.ADDED_TO_STAGE, initStage, false, 0, true);
			}
		}
		
		/**
		 * Revisa que de donde se está corriendo el .swf es nuestro dominio
		 */
		private function correctDomain():Boolean{
			var url:String = loaderInfo.url;
			var domain:String = url.slice(url.search("://") + 3);
			domain = domain.substr(0, domain.search("/"));
			for (var i:int = 0; i< allowedSite.length; ++i) {
				if (allowedSite[i] == domain) {
					return(true);
				}
			}
			return(false);
		}
		
		/**
		 * Cuando sea agregado al 'stage'
		 */
		private function initStage(e:Event):void {			
			// Revisamos que este corriendo desde nuestra página
			//if (correctDomain()) {
				// Datos para el 'stage'
				currStage = stage;
				stage.stageFocusRect = false;
				Section.setSize(stage.stageWidth, stage.stageHeight);
				// Cargamos los datos
				Database.loadData();				
				// Creamos e inicializamos la seccion que se va a utilizar
				currSect = new MainMenu();
				addChild(currSect);
				// Inicializamos el tiempo
				time = getTimer();
				// Agregamos eventos
				addEventListener(Event.ENTER_FRAME, onEnterFrame, false, 0, true);
				addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove, false, 0, true);
			//}
		}

		/**
		 * Cada que entra en la escena
		 */
		private function onEnterFrame(event:Event):void {
			var lastTime:int = time;
			time = getTimer();
			currSect.update((time -lastTime)/1000);
			if (currSect.finished) {
				nextSect = currSect.nextSection;
				removeChild(currSect);
				currSect = nextSect;
				addChild(currSect);
				stage.focus = currSect;
			}
		}
		
		/**
		 * Para controlar el mouse
		 */
		private function onMouseMove(e:MouseEvent):void {
			pointerX = e.stageX;
			pointerY = e.stageY;
		}
	}
}