/***********************************************************
 * main.cpp                                                *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/

#include "constants.h"
#include "http-server.h"
#include "logger.h"


int main(int argc, char* argv[]) {
   HttpServer server;
   Logger::log.start(Const::VERBOSITY, Const::LOG_FILE);
   try {
      if (argc == 1) {
         server.init();
      } else if (argc == 2) {
         server.init(argv[1]);
      } else {
         server.init(argv[1], argv[2]);
      }
      server.start();
   } catch (string error) {
      Logger::log.write(Logger::ERROR, error);
   }
   Logger::log.close();

   return 0;
}
