/***********************************************************
 * logger.h                                                *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/
#pragma once

#include <fstream>
#include <iostream>
#include <string>
using namespace std;


class Logger {
public:
   // Enumerators
   enum Level {                           // Levels of verbosity
      ERROR,
      WARNING,
      INFO,
      NONE
   };
   // Fields
   static Logger log;                     // Singleton
   // Methods
   void start(Level, string);             // Starts the log, setting verbosity and output file
   void write(Level, const string);       // Writes into the log, if the verbosity fits
   void write(Level, const string, int);  // Writes into the log both the message and the socket
   void flush();                          // Flushes the log
   void close();                          // Closes the log
private:
   // Fields
   ofstream stream;                       // Stream where used to write everything
   Level verbosity;                       // Current level of verbosity (highest that can be written)
   Level prevLevel;                       // Previous verbosity level written into the log
   // Methods
   Logger();                              // Empty constructor (to enfornce singleton pattern)
   Logger(Logger const&);                 // Copy constructor (to enfornce singleton pattern)
   Logger& operator=(Logger const&);      // Assignment (to enfornce singleton pattern)
};
