/***********************************************************
 * logger.cpp                                              *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/

#include "logger.h"
#include <sstream>


// Declares singleton
Logger Logger::log;


// Starts the log, setting verbosity and output file
void Logger::start(Level level, string file) {
   verbosity = level;
   stream.open(file.c_str(), ios::app);
}


// Writes into the log, if the verbosity fits
void Logger::write(Level level, const string message) {
   if (level <= verbosity) {
      // Get current time
      time_t rawTime = time(NULL);
      struct tm* timeInfo = localtime(&rawTime);
      if (prevLevel != level) {
         // Write time and message
         switch (level) {
            case ERROR:
               stream << "--- ERROR,   " << asctime(timeInfo);
               break;
            case WARNING:
               stream << "--- WARNING, " << asctime(timeInfo);
               break;
            case INFO:
            default:
               stream << "--- INFO,    " << asctime(timeInfo);
               break;
         }
      }
      prevLevel = level;
      stream << message << endl;
   }
}


// Writes into the log both the message and the socket
void Logger::write(Level level, const string message, int socket) {
   stringstream out;
   out << message << " " << socket;
   write(level, out.str());
}


// Flushes the log
void Logger::flush() {
   prevLevel = NONE;
   stream.flush();
}


// Closes the log
void Logger::close() {
   stream.close();
}


// Empty constructor (to enfornce singleton pattern)
Logger::Logger () {
   prevLevel = NONE;
}


// Copy constructor (to enfornce singleton pattern)
Logger::Logger (Logger const&) {
   prevLevel = NONE;
}


// Assignment (to enfornce singleton pattern)
Logger& Logger::operator=(Logger const&) {
   return *this;
}  
