/***********************************************************
 * http-server.h                                           *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/
#pragma once

#include "client.h"
#include "constants.h"
#include <netdb.h>
#include <string>
#include <vector>
using namespace std;


class HttpServer  {
public:
   // Fields
   vector<Client *> clients;              // List of clients currently connected
   // Methods
   void init(string = Const::DEFAULT_MODE, string = Const::DEFAULT_PORT);  // Initializes the server
   void start();                          // Starts the server
private:
   // Fields
   int socketDescriptor;                  // The socket file descriptor for the initial connection
   int maxDescriptor;                     // Largest discriptor number
   fd_set connectedUsers;                 // The set of users (socket descriptions) connected
   string httpMode;                       // Mode to be used by the server
   // Methods
   addrinfo* localAddressInfo(string);    // Gets information about host address
   void* getInAddr(sockaddr *);           // Gets whether the socket address is IPv4 or IPv6
   void findBind(addrinfo *);             // Searches where to bind to
   void startListening();                 // Starts listening for incoming connections
   fd_set listenForConnections();         // Listen the ports for connections
   void acceptConnections(fd_set *);      // Accept new connections 
};
