/***********************************************************
 * constants.h                                             *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/
#pragma once

#include "logger.h"
#include <string>
using namespace std;


class Const {
public:
   // Server constants
   static const unsigned int QUEUE_SIZE;           // Maximum amount of connections that can be queued
   static const unsigned int LISTEN_TIMEOUT;       // Amount of time to listen for new connections (in us)
   static const unsigned int CONNECTION_TIMEOUT;   // Amount of (shared) time given to connections before timeout
   static const unsigned int BUFFER_SIZE;          // Size of buffer to receive incoming messages
   static const string DEFAULT_PORT;      // Default port to connect if unspecified
   static const string DEFAULT_MODE;      // Default http mode if unspecified or not recognized
   static const string DEFAULT_FILE;      // Default file to retreive if unspecified
   static const string ROOT;              // Local directory of the server (root)
   // Http character constants
   static const string SP;                // Space character
   static const string CRLF;              // Line break
   // Media type of the entity-body sent (for content-type header)
   static const string TYPE_HTML;         // For html text
   static const string TYPE_GIF;          // For gif images
   static const string TYPE_JPG;          // For jpg images
   static const string TYPE_MESSAGE;      // For when replying a TRACE
   // Http status codes and reason phrases
   static const string CODE_200;          // The request succeeded
   static const string CODE_204;          // Server fulfilled the request and doesn't need to return an entity-body
   static const string CODE_400;          // Bad request
   static const string CODE_403;          // Forbidden
   static const string CODE_404;          // Not found
   static const string CODE_500;          // Internal service error
   static const string CODE_505;          // Http version not supported
   // Logging constants
   static const string LOG_FILE;          // File to log all messages
   static const Logger::Level VERBOSITY;  // Level of verbosity
};
