/***********************************************************
 * constants.cpp                                           *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/

#include "constants.h"


// Server constants
const unsigned int Const::QUEUE_SIZE = 10;
const unsigned int Const::LISTEN_TIMEOUT = 50000;
const unsigned int Const::CONNECTION_TIMEOUT = 10;
const unsigned int Const::BUFFER_SIZE = 65536;
const string Const::DEFAULT_PORT = "8128";
const string Const::DEFAULT_MODE = "1.0";
const string Const::DEFAULT_FILE = "index.html";
const string Const::ROOT = "";

// Http character constants
const string Const::SP = " ";
const string Const::CRLF = "\r\n";

// Media type of the entity-body sent (for content-type header)
const string Const::TYPE_HTML = "text/html;";
const string Const::TYPE_GIF = "image/gif;";
const string Const::TYPE_JPG = "image/jpg;";
const string Const::TYPE_MESSAGE = "message/http";

// Http status codes and reason phrases
const string Const::CODE_200 = "200" + Const::SP + "OK";
const string Const::CODE_204 = "204" + Const::SP + "204 No Content";
const string Const::CODE_400 = "400" + Const::SP + "Bad Request";
const string Const::CODE_403 = "403" + Const::SP + "Forbidden";
const string Const::CODE_404 = "404" + Const::SP + "Not Found";
const string Const::CODE_500 = "500" + Const::SP + "Server Error";
const string Const::CODE_505 = "505" + Const::SP + "HTTP Version Not Supported";

// Log fiel constants
const string Const::LOG_FILE = "log.txt";
const Logger::Level Const::VERBOSITY = Logger::INFO;
