/***********************************************************
 * client.h                                                *
 *                                                         *
 * Pier Guillen (pguillen)                                 *
 * CS 536 - Assignment 1                                   *
 * Feb 7, 2011                                             *
 ***********************************************************/
#pragma once

#include <netdb.h>
#include <ctime>
#include <string>
using namespace std;


class Client {
public:
   // Methods
   Client(int, string, string);     // Constructor, receive the desciptor and address of the client
   void listenForRequests(fd_set*); // Listen for incoming requests
   void receiveRequest();           // Receive incoming request from the client
   void parseRequest();             // Parse the client request
   void appendRequest();            // Append information to the body of the request
   void processRequest();           // Process the client's request
   void transmitContent();          // Transmit content to the client
   bool closeConnection(fd_set*, int);    // Close unused connections from clients
private:
   // Enumerators
   enum State {                     // States the client can be in (state machine)
      LISTEN,
      RECEIVE,
      PARSE,
      APPEND,
      PROCESS,
      TRANSMIT,
      CLOSE
   };
   // Fields
   int descriptor;                  // Client socket descriptor
   time_t startTime;                // Time when the last request started (for HTTP 1.1)
   string address;                  // Client address
   string path;                     // Request path (file the client is asking for)
   string method;                   // Request method (action the client is requesting)
   string version;                  // Request version (http version the client uses)
   string connectionHeader;         // Options that are desired by the client for the connection
   string contentLenHeader;         // The size of the entity-body, in decimal number of OCTETs
   string contentTypeHeader;        // The media type of the entity-body sent to the recipient
   string dateHeader;               // The date and time at which the request message was originated
   string hostHeader;               // The Internet host and port number of the requested resource 
   string entityBody;               // The body of the request
   string request;                  // Request sent by the client
   string response;                 // Response sent back to the client
   string serverHttpMode;           // The mode used by the http server
   State currState;                 // Current state of the client
   // Methods
   string createResponse(string, string); // Creates the response to a successful request
   string createErrorHtml(int);     // Creates an html file containg the provided error
   string getError(int);            // Gets a string with status code and reason phrase of the error
   string createErrorResponse(int); // Creates the response to be sent when encountering an error
   void processGetHead(bool);       // Process a GET/HEAD request
   void processGet();               // Process a GET request
   void processHead();              // Process a HEAD request
   void processPut();               // Process a PUT request
   void processDelete();            // Process a DELETE request 
   void processTrace();             // Process a TRACE request
   void processOptions();           // Process an OPTION request
};
