// We create the 'data' type in which we're going to store the tanks data
// (not necessary, but helps keeping the code clean).
Type
    data = record
         dir: char;                // Direction of the tank
         x, y, delta: longint;     // (x, y) coordinates and difference between hits and kills
         end;

// We create an array with all of the instructions (also not necessary)
Const
     instr: array [0..4] of char = ('A', 'R', 'I', 'D', 'S');

Var
   i: longint;                     // Used for the loops
   player: array [0..3] of data;   // Used to store the info of each player

Begin
     // We assign 'datos.txt' for the input and 'salida.txt' for the output
     assign(input,'datos.txt');  reset(input);
     assign(output,'salida.txt'); rewrite(output);

     // We read the data of all the players (we are player[0])
     for i:= 0 to 3 do
         with player[i] do
              begin
              readln(input, delta, x, y, dir, dir);
              end;

     // Here goes the strategy (right now we're only going to give a random instruction)
     randomize;
     writeln(output, instr[random(5)]);

     // We close the files (very important for the output!)
     close(input);
     close(output);
End.
