// Libraries to include
#include <iostream>
#include <fstream>
#include <cstdlib>   // Random number generator
#include <ctime>     // To seed random generator
using namespace std;

// We create the 'TankData' class in which we're going to store the tanks info
class TankData {
   public:
      void Read(ifstream& input) {input >> delta >> x >> y >> dir;}
   private:
      char dir;      // Direction of the tank
      long x;        // X coordinate
      long y;        // Y coordinate
      long delta;    // Difference between hits and kills
};

// We create an array with all of the instructions and an array to store the info of each player
const int numInstr= 5;
const int numPlayers= 4;
TankData player[numPlayers];
const char instr[numInstr] = {'A', 'R', 'I', 'D', 'S'};

int main(void) {
   // We assign 'datos.txt' for the input and 'salida.txt' for the output
   ifstream input("datos.txt");
   ofstream output("salida.txt");

   // We read the data of all the players (we are player[0])
   for (int i= 0; i< numPlayers; ++i) {
      player[i].Read(input);
   }

   // Here goes the strategy (right now we're only going to give a random instruction)
   srand((unsigned) time(NULL));
   output << instr[rand() % numInstr] << endl;

   // We close the files and exit (very important for stdout!)
   input.close();
   output.close();
   return (0);
}
