// Libraries to include
#include <stdio.h>
#include <time.h>    // To seed random generator

// We define constants
#define PLAYERS         4
#define INSTRUCTIONS    5

// We create the 'stTankData' type in which we're going to store the tanks data
// (not necessary, but helps keeping the code clean).
typedef struct {
   char cDir;     // Direction of the tank
   long iX;       // X coordinate
   long iY;       // Y coordinate
   long iDelta;   // Difference between hits and kills
} stTankData;

// We create an array with all of the instructions (also not necessary),
// and an array to store the info of each player
stTankData tPlayer[PLAYERS];
const char acInstr[INSTRUCTIONS] = {'A', 'R', 'I', 'D', 'S'};

int main(void) {
   int i;

   // We assign 'datos.txt' for the input and 'salida.txt' for the output
   freopen("datos.txt", "rt", stdin);
   freopen("salida.txt", "wt", stdout);

   // We read the data of all the players (we are tPlayer[0])
   for (i= 0; i< PLAYERS; ++i) {
      scanf("%ld %ld %ld %c\n", &tPlayer[i].iDelta, &tPlayer[i].iX, 
         &tPlayer[i].iY, &tPlayer[i].cDir);
   }

   // Here goes the strategy (right now we're only going to give a random instruction)
   srand((unsigned) time(NULL));
   printf("%c", acInstr[rand() % INSTRUCTIONS]);

   // We close the files and exit (very important for stdout!)
   fclose(stdin);
   fclose(stdout);
   return (0);
}
