/***********************************************************
 *                                                         *
 *  winners.c                                              *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Funciones en las que se calculan  y muestran *
 *          los ganadores.                                 *
 *                                                         *
 ***********************************************************/


// Librerias a incluir
#include "winners.h"
#include "memory.h"
#include "time.h"
#include "fade.h"
#include "config.h"
#include "random.h"
#include "tanks.h"
#include "constants.h"
#include "grabber.h"
#include <alfont.h>
#include <allegro.h>
#include <fmod.h>
#include <stdio.h>


// Constantes
#define NUM_RANKS                6                    // Cuantos "ranks" (ganadores) hay
#define NUM_TOP_PLACES           4                    // Cuantos ganadores se toman de los mejores puntajes
#define TEXT_SEP_X             120                    // Distancia de separacion de los textos en x
#define TEXT_SEP_Y              30                    // Distancia de separacion de los textos en y
#define MAX_SIZE               800                    // Tamao mximo cuando se "estiran" los textos
#define TOT_TIME               350                    // Tiempo en cada transicin cuando se "estira" el texto
#define DROP_WIDTH               5                    // Ancho de las gotas
#define DROP_START_HEIGHT      250                    // Max value for the random start of the drops
#define DROP_MIN_VEL         12500                    // Min speed for the drops
#define DROP_MAX_VEL         25000                    // Max speed for the drops
#define DROP_VEL_DIV           100.0                  // Divides the speed
#define NUM_DROPS    (SCREEN_WIDTH/DROP_WIDTH)        // Cantidad de gotas
const char szRank[NUM_RANKS][STRING_SIZE] = {
   "GENERAL", "CORONEL", "CAPTAIN", "LIEUTENANT",
   "ARTILLERY_OFICIAL", "CHIEF_OF_DEFENSE"
};
const int aiPosX[NUM_RANKS] = {
   100, 100, 100, 100, 600, 200
};
const int aiPosY[NUM_RANKS] = {
   150, 220, 290, 360, 470, 470
};
const int aiTextPosX[NUM_RANKS] = {
   280, 280, 280, 280, 440, 30
};
const int aiTextPosY[NUM_RANKS] = {
   150, 220, 290, 360, 520, 520
};


// Variables
static stIntList tDfnsList;
static stIntList tAttkList;
static stIntList tWinList[NUM_TOP_PLACES];
static BITMAP *bmpSky;
static BITMAP *bmpLast;
static BITMAP *bmpRank[NUM_RANKS];
static ALFONT_FONT *fontUser;
static FSOUND_STREAM *sndChampions;
extern BITMAP *g_bmpBuffer;
extern stPlayerData *atPlayer;


// Cargamos e inicializamos datos de la secuencia de ganadores
void init_winners_sequence(void) {
   int i;

   bmpLast= create_bitmap(SCREEN_WIDTH, SCREEN_HEIGHT);
   // Cargamos datos desde los archivos
   bmpSky = load_png_from_dat("BACKGROUND", RANKING_FILE);
   for (i = 0; i < NUM_RANKS; ++i) {
      bmpRank[i]= load_png_from_dat(szRank[i], RANKING_FILE);
   }   
   fontUser = load_font_from_dat("LOVE", FONTS_FILE, 15);
}      


// Cerramos datos
void close_winners_sequence(void) {
   int i;

   // Paramos el sonido y dejamos el volumen al maximo
   FSOUND_StopSound(FSOUND_ALL);
   FSOUND_SetVolume(FSOUND_ALL, 255);

   // Liberamos memoria
   destroy_bitmap(bmpLast);
   destroy_bitmap(bmpSky);
   for (i = 0; i < NUM_RANKS; ++i) {
      destroy_bitmap(bmpRank[i]);
   }
   alfont_destroy_font(fontUser);
}


// Encuentra quienes son los ganadores 
void calculate_winners(int iNumPlayers) {
   int i;
   int j;
   int iLimit;
   int iMaxKills;
   int iMinDeads;
   int iMaxPoints;
   
   // Encontramos a los mejores atacantes y defensores
   iMaxKills = 0;
   iMinDeads = 1 << 30;
   for (i= 0; i< iNumPlayers; ++i) {
      if (atPlayer[i].iKills  > iMaxKills) {
         tAttkList.iSize= 1;
         iMaxKills= atPlayer[i].iKills;
      } else if (atPlayer[i].iKills == iMaxKills)  {
         tAttkList.iSize++;
      }
      if (atPlayer[i].iDeads < iMinDeads) {
         tDfnsList.iSize= 1;
         iMinDeads= atPlayer[i].iDeads;
      } else if (atPlayer[i].iDeads == iMinDeads) {
         tDfnsList.iSize++;
      }
   }

   // Guardamos a los mejores atacantes y defensores
   tAttkList.iPos= 0;
   tAttkList.piData= (int *)safe_malloc(tAttkList.iSize*sizeof(int));
   tDfnsList.iPos= 0;
   tDfnsList.piData= (int *)safe_malloc(tDfnsList.iSize*sizeof(int));
   for (i= 0; i< iNumPlayers; ++i) {
      if (atPlayer[i].iKills == iMaxKills) {
         tAttkList.piData[tAttkList.iPos]= i;
         tAttkList.iPos++;
      }
      if (atPlayer[i].iDeads == iMinDeads) {
         tDfnsList.piData[tDfnsList.iPos]= i;
         tDfnsList.iPos++;
      }
   }

   // Encontramos quienes tienen los mejores puntajes
   iLimit= 1 << 30;
   for (j= 0; j< NUM_TOP_PLACES; ++j) {
      iMaxPoints = 0;
      tWinList[j].iSize= 0;
      for (i= 0; i< iNumPlayers; ++i) {
         if ((atPlayer[i].iPoints  > iMaxPoints) && (atPlayer[i].iPoints < iLimit)) {
            tWinList[j].iSize= 1;
            iMaxPoints= atPlayer[i].iPoints;
         } else if (atPlayer[i].iPoints == iMaxPoints)  {
            tWinList[j].iSize++;
         }
      }
  
      iLimit= iMaxPoints;
      tWinList[j].iPos= 0;
      tWinList[j].piData= (int *)safe_malloc(tWinList[j].iSize*sizeof(int));
      for (i= 0; i< iNumPlayers; ++i) {
         if (atPlayer[i].iPoints == iMaxPoints) {
            tWinList[j].piData[tWinList[j].iPos]= i;
            tWinList[j].iPos++;
         }
      }
   }
}


// Guardamos los resultados en un archivo de texto
void save_results(int iNumPlayers) {
   int i;
   int j;

   freopen(RESULTS_FILE , "wt", stdout);
   
   // Ponemos los ganadores
   printf(" - Mejores Jugadores\n");
   for (j= 0; j< NUM_TOP_PLACES; ++j) {
      if (tWinList[j].iSize != 0) {
         printf("%d Lugar (%d puntos):\n", j+1, atPlayer[tWinList[j].piData[0]].iPoints);
         for (i= 0; i< tWinList[j].iSize-1; ++i) {
            printf("%s;", atPlayer[tWinList[j].piData[i]].szName);
         }
         printf("%s\n\n", atPlayer[tWinList[j].piData[i]].szName);
      }
   }
   printf("Mejor Ataque (%d muertos):\n", atPlayer[tAttkList.piData[0]].iKills);
   for (i= 0; i< tAttkList.iSize -1; ++i) {
      printf("%s;", atPlayer[tAttkList.piData[i]].szName);
   }
   printf("%s\n\n", atPlayer[tAttkList.piData[i]].szName);
   
   printf("Mejor Defensa (%d muertes):\n", atPlayer[tDfnsList.piData[0]].iDeads);
   for (i= 0; i< tDfnsList.iSize -1; ++i) {
      printf("%s;", atPlayer[tDfnsList.piData[i]].szName);
   }
   printf("%s\n\n\n", atPlayer[tDfnsList.piData[i]].szName);

   // Ponemos los resultados de cada jugador
   printf(" - Resultados por Jugador\n");
   for (i= 0; i< iNumPlayers; ++i) {
      printf("%s:\tA favor= %d,\tEn contra= %d,\tPuntos= %d,\tPorciento= %1.2f\n", 
         atPlayer[i].szName, atPlayer[i].iKills, atPlayer[i].iDeads, 
         atPlayer[i].iPoints, 
         (100.0*atPlayer[i].iPoints)/atPlayer[tWinList[0].piData[0]].iPoints);
   }

   fclose(stdout);
}


// "Escurre" la pantalla
void exit_sequence(void) {
   int i;
   int iPixColor;
   int iActiveDrops;
   int abActiveDrop[NUM_DROPS];
   float fDT;
   float fDelta;
   float fLastTime;
   float afDropPos[NUM_DROPS];
   float afDropVel[NUM_DROPS];
   
   // Datos iniciales
   iActiveDrops = NUM_DROPS;
   for (i = 0; i < NUM_DROPS; ++i) {
      afDropPos[i] = -random_num(DROP_START_HEIGHT);
      afDropVel[i] = random_range(DROP_MIN_VEL, DROP_MAX_VEL) / DROP_VEL_DIV;
      abActiveDrop[i] = TRUE;
   }

   // Ciclo en el que "escurren" las lineas
   fDT = 0;
   fLastTime = 0;
   clear_count();
   draw_sprite(g_bmpBuffer, bmpLast, 0, 0);
   while (iActiveDrops) {
      for (i = 0; i < NUM_DROPS; ++i) {
         if (abActiveDrop[i]) {
            fDelta = afDropVel[i] * fDT;
            rectfill(g_bmpBuffer, i*DROP_WIDTH, (int)afDropPos[i],
               (i+1)*DROP_WIDTH -1, (int)(afDropPos[i] + fDelta), makecol(0,0,0));
            afDropPos[i] += fDelta;
            if (afDropPos[i] >= SCREEN_HEIGHT) {
               iActiveDrops--;
               abActiveDrop[i] = FALSE;
            }
         }
      }
      draw_sprite (screen, g_bmpBuffer, 0, 0);
      fDT = (float) return_count() / 1000 - fLastTime;
      fLastTime += fDT;
   }
}


// Muestra quienes fueron los ganadores
void display_winners(void) {
   int i;
   int j;
   int iTime;
   int iWidth;
   int iHeight;   
   stIntList *ptList;
   
   sndChampions = FSOUND_Stream_Open(RANKING_SONG, FSOUND_2D, 0,0);
   FSOUND_Stream_Play(FSOUND_FREE, sndChampions);
   fade_media_in(bmpSky, 2500, 0, 0, makecol(0,0,0));

   clear_clock();
   wait_clock(5000, TRUE);
   draw_sprite(bmpLast, bmpSky, 0, 0);
   for (i= NUM_RANKS -1; i>= 0; --i) {
      // Si estamos en el ranking principal
      if ((i < NUM_RANKS -2) && (0 < i)) {
         // Nos saltamos a los que no sacaron puntos (a menos que todos no hayan sacado puntos)
         if ((tWinList[i].iSize == 0) ||
            (atPlayer[tWinList[i].piData[0]].iPoints <= 0)) {
            continue;
         }
      }

      // Pone el "titulo" de la posicion
      iTime = 0;
      clear_count();
      while (iTime<= 2*TOT_TIME) {
         draw_sprite(g_bmpBuffer, bmpLast, 0, 0);
         if (iTime< TOT_TIME) {
            // De casi horizontal a casi vertical
            iWidth = MAX_SIZE -(MAX_SIZE*iTime)/TOT_TIME;
            iHeight = (MAX_SIZE*iTime)/TOT_TIME;
         } else {
            // De casi vertical a normal
            iWidth = (bmpRank[i]->w*iTime)/TOT_TIME - bmpRank[i]->w;
            iHeight = ((bmpRank[i]->h -MAX_SIZE)*iTime)/TOT_TIME + 2*MAX_SIZE -bmpRank[i]->h;
         }
         stretch_sprite(g_bmpBuffer, bmpRank[i], aiPosX[i] -iWidth/2, 
            aiPosY[i] -iHeight/2, iWidth, iHeight);
         draw_sprite(screen, g_bmpBuffer, 0, 0);
         iTime = return_count();
      }
      draw_sprite(bmpLast, bmpRank[i], aiPosX[i] -bmpRank[i]->w/2, aiPosY[i] -bmpRank[i]->h/2);
      draw_sprite(screen, bmpLast, 0, 0);
      wait_clock(2500, TRUE);

      // Escribe quienes ganaron y cuantos puntos (o muertes) tuvieron
      if (i == NUM_RANKS -1) {
         // Ponemos los jugadores con mejor defensa
         alfont_textprintf_aa(bmpLast, fontUser, aiTextPosX[i], aiTextPosY[i], 0, 
            "%d caidos", atPlayer[tDfnsList.piData[0]].iDeads);
         ptList = &tDfnsList;
      } else if (i == NUM_RANKS -2) {
         // Ponemos los jugadores con mejor ataque
         alfont_textprintf_aa(bmpLast, fontUser, aiTextPosX[i], aiTextPosY[i], 0,
            "%d eliminados", atPlayer[tAttkList.piData[0]].iKills);
         ptList = &tAttkList;
      } else {
         // Ponemos los mejores jugadores
         alfont_textprintf_aa(bmpLast, fontUser, aiTextPosX[i], aiTextPosY[i], 0,
            "%d puntos", atPlayer[tWinList[i].piData[0]].iPoints);
         ptList = &tWinList[i];
      }
      draw_sprite(screen, bmpLast, 0, 0);
      wait_clock(2000, TRUE);
      for (j = 0; j< ptList->iSize; ++j) {         
         alfont_textprintf_aa(bmpLast, fontUser, aiTextPosX[i] + TEXT_SEP_X*(j/2 + 1),
            aiTextPosY[i] + TEXT_SEP_Y*(j%2), 0, "%s", atPlayer[ptList->piData[j]].szName);         
         draw_sprite(screen, bmpLast, 0, 0);
         wait_clock(1500, TRUE);
      }
      wait_clock(3500, TRUE);
   }

   // Esperamos a que se acabe la cancion
   while (FSOUND_Stream_GetPosition(sndChampions) < FSOUND_Stream_GetLength(sndChampions)) {
   }

   // Nos salimos   
   exit_sequence();
   FSOUND_Stream_Close(sndChampions);
}


// Secuencia de ganadores
void winners_sequence(int iNumPlayers) {
   init_winners_sequence();
   calculate_winners(iNumPlayers);
   save_results(iNumPlayers);
   display_winners();
   close_winners_sequence();
}
