/***********************************************************
 *                                                         *
 *  tanks.h                                                *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Header de las funciones principales de la    *
 *           batalla.                                      *
 *                                                         *
 ***********************************************************/
 
#ifndef TANKS_H
#define TANKS_H
 
// Incluimos librerias
#include "constants.h"
#include <allegro.h>
#include <fmod.h>


// Definimos estructuras
typedef struct _stObject {
   int iX;                             // Posicion en X
   int iY;                             // Posicion en Y
   int iCurrFrame;                     // Imagen en el que se encuentra
   int iNumFrames;                     // Numero de imagenes
   int bActive;                        // Para saber si lo dibujamos
   BITMAP *bmpSprite[MAX_SPRITES];     // Imagenes
} stObject;                            // Estructura de los objetos

typedef struct _stPlayerData {
   int iX;                             // Posicion en X
   int iY;                             // Posicion en Y
   int iDX;                            // Cambio en la posicion en X
   int iDY;                            // Cambio en la posicion en Y
   int iKills;                         // Cantidad de tanques que ha eliminado
   int iDeads;                         // Cantidad de veces que lo han eliminado
   int iMatchKills;                    // Cantidad de tanques que ha eliminado en la pelea actual
   int iMatchDeads;                    // Cantidad de veces que lo han eliminado en la pelea actual
   int iMatchDelta;                    // Diferencia entre la cantidad de veces que mato y que lo mataron
   float fAngle;                       // Angulo en el que se encuentra (para los giros)
   int iDirection;                     // Direccion en la que se encuentra
   int iPoints;                        // Cantidad de puntos totales que lleva
   int iMatchPoints;                   // Cantidad de puntos que lleva en la pelea actual
   int iFights;                        // Cuantos enfretamientos lleva
   int iColor;                         // Color que utiliza
   int iNum;                           // Numero de jugador
   char szName[STRING_SIZE];           // Nombre del participante
   char szProgram[STRING_SIZE];        // Programa que utiliza
   BITMAP *bmpTank;                    // Imagen del tanque
} stPlayerData;                        // Estructura de los participantes

typedef struct _stStage {
   int iRound;                         // Numero del nivel
   int aiStageOrder[NUM_STAGES];       // Orden en el que vamos a utilizar los niveles
   FSOUND_STREAM *sndSong;             // Cancion a utilizar
   BITMAP *bmpMap;                     // Mapa a utilizar
   BITMAP *bmpBackground;              // Fondo de pantalla
   stObject atSmallTank[NUM_PLAYERS_SCREEN];             // Imagenes de los tanques desde arriba 
   stPlayerData *patCurrentPlayer[NUM_PLAYERS_SCREEN];   // Datos de las personas que estan jugando
} stStage;

// Declaramos funciones
void tanks_battle(void);               // Secuencia principal del juego
void init_players(int);                // Inicializa la estructura de los jugadores
void init_game_data(int);              // Inicializamos los datos que vamos a utilizar en todo el juego
void init_battle(int);                 // Valores que se necesitan inicializar en cada ronda
void close_game_data(int);             // Quitamos de memoria los datos
void update_screen(void);              // Ponemos las imagenes en pantalla
void update_actions(stPlayerData *, char);   // Actualiza al tanque de acuerdo a la opcion que eligi
 
#endif
