/***********************************************************
 *                                                         *
 *  tanks.c                                                *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Funciones principales de la batalla.         *
 *                                                         *
 ***********************************************************/

// Librerias a incluir
#include "tanks.h"
#include "time.h"
#include "fade.h"
#include "config.h"
#include "error.h"
#include "memory.h"
#include "random.h"
#include "screens.h"
#include "grabber.h"
#include "winners.h"
#include <alfont.h>
#include <allegro.h>
#include <fmod.h>
#include <stdio.h>
#include <string.h>


// Variables globales
stPlayerData *atPlayer;             // Apunta al bloque de memoria donde estan los datos (lo usamos como arreglo)
stPlayerData *patCurrentPlayer[NUM_PLAYERS_SCREEN];   // Apunta a los datos de los jugadores en pantalla
FSOUND_SAMPLE *sndBomb;
FSOUND_SAMPLE *sndShot;

// Variables
static int iTimePerTurn;
static stStage tStage;
static stObject tShot;
static stObject atExplosion[NUM_PLAYERS_SCREEN];
static int aiCollision[GRID_SIZE+2][GRID_SIZE+2];
static BITMAP *abmpTankImages[NUM_TANK_IMAGES];
extern BITMAP *g_bmpBuffer;

// Constantes
const int aiStartCoord[NUM_PLAYERS_SCREEN][2]= {            // Coordenadas en la que inician los tanques
   {2, GRID_SIZE}, {GRID_SIZE, GRID_SIZE -1}, 
   {GRID_SIZE -1, 1}, {1, 2}
}; 
const int aiColor[NUM_PLAYERS_SCREEN][3] = {                // Colores de los tanques
   {255,   0,   0},     // Rojo
   {  0,   0, 255},     // Azul
   {  0, 255,   0},     // Verde
   {255, 224,   0}      // Amarillo
};
const int aiMovement[4][2] = {                              // Movimientos (Este, Sur, Oeste, Norte)
   {1, 0}, {0, -1}, {-1, 0}, {0, 1}
};
const char acInstruction[NUM_INSTRUCTIONS]= {               // Instrucciones
   'A', 'R', 'I', 'D', 'S', 'N'
};
const char szTanks[NUM_TANK_IMAGES][STRING_SIZE] = {        // Imagenes de los tanques
   "RED1", "BLUE1", "GREEN1", "YELLOW1",
   "RED2", "BLUE2", "GREEN2", "YELLOW2",
   "RED3", "BLUE3", "GREEN3", "YELLOW3",
   "RED4", "BLUE4", "GREEN4", "YELLOW4"
};
const char szTanksAbove[NUM_PLAYERS_SCREEN][STRING_SIZE] = {// Imagenes de los tanques desde arriba
   "RED_ABOVE", "BLUE_ABOVE", "GREEN_ABOVE", "YELLOW_ABOVE"
};
const char szMaps[NUM_STAGES][STRING_SIZE] = {              // Imagenes de los mapas
   "MAP1", "MAP2", "MAP3", "MAP4", 
   "MAP5", "MAP6", "MAP7", "MAP8"
};
const char szSongs[NUM_STAGES][STRING_SIZE] = {             // Canciones
   "music/map01.mp3", "music/map02.mp3", "music/map03.mp3", 
   "music/map04.mp3", "music/map05.mp3", "music/map06.mp3",
   "music/map07.mp3", "music/map08.mp3"
};



// Inicializa la estructura de los jugadores
void init_players(int iNumPlayers) {
   int i;

   if (freopen(PLAYERS_FILE, "rt", stdin)== NULL) {
      error_message("Error al cargar los datos de los jugadores.\n\
         No se pudo abrir el archivo con los jugadores.");
   }

   atPlayer= (stPlayerData*)safe_malloc(iNumPlayers*sizeof(stPlayerData));
   for (i= 0; i< iNumPlayers; ++i) {
      if (feof(stdin)) {
         error_message("Error al cargar los datos de los jugadores.\n\
            El archivo tiene menos jugadores que los que debiera.");
      }
      scanf("%s", &atPlayer[i].szProgram);
      scanf("%[^\n]", &atPlayer[i].szName);
      atPlayer[i].iPoints= 0;
      atPlayer[i].iFights= 0;
      atPlayer[i].iKills = 0;
      atPlayer[i].iDeads = 0;
   }
}


// Inicializamos los datos que vamos a utilizar en todo el juego
void init_game_data(int iNumPlayers) {
   int i;
   int j;
   char pzName[STRING_SIZE];
   
   // Empezamos en el primer round
   tStage.iRound= 0;
   
   // Inicializamos a los jugadores
   init_players(iNumPlayers);

   // Cargamos Sonidos de Efectos
   sndBomb = load_sound_from_dat("EXPLOSION", SOUND_FILE);
   sndShot = load_sound_from_dat("SHOT", SOUND_FILE);

   // Cargamos Imagenes
   tStage.bmpBackground = load_png_from_dat("MAIN", BACKGROUND_FILE);
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      tStage.atSmallTank[i].iCurrFrame= 0;
      tStage.atSmallTank[i].iNumFrames= 1;
      tStage.atSmallTank[i].bmpSprite[0]= load_png_from_dat(szTanksAbove[i], TANKS_FILE);
   }
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      atExplosion[i].iCurrFrame= 0;
      atExplosion[i].iNumFrames= EXPLOSION_FRAMES;
      for (j= 0; j< EXPLOSION_FRAMES; ++j) {
         sprintf(pzName, "EXPLOSION%02d", j+1);
         atExplosion[i].bmpSprite[j] = load_png_from_dat(pzName, ARMAMENT_FILE);
      }
   }
   for (i= 0; i< NUM_TANK_IMAGES; ++i) {
      abmpTankImages[i] = load_png_from_dat(szTanks[i], TANKS_FILE);
   }
   tShot.iCurrFrame= 0;
   tShot.iNumFrames= 1;
   tShot.bmpSprite[0] = load_png_from_dat("BULLET", ARMAMENT_FILE);
}


// Valores que se necesitan inicializar en cada ronda
void init_battle(int iNumPlayers) {
   int i;
   int iTank;
   int aiTemp[NUM_PLAYERS_SCREEN ];
   
   // Leemos cuales jugadores van a participar
   for (i= 0; i< NUM_PLAYERS_SCREEN ; ++i) {
      scanf("%d", &aiTemp[i]);
      if (aiTemp[i] > iNumPlayers) {
         error_message("Error al leer el archivo de jugadas: Datos invalidos.");
      }
      patCurrentPlayer[i]= &atPlayer[aiTemp[i] -1];
   }
   scanf("\n");

   // Inicializamos las colisiones
   memset(aiCollision, 0, sizeof(aiCollision));
   for (i= 0; i<= GRID_SIZE + 1; ++i) {
      aiCollision[0][i]          = WALL;
      aiCollision[GRID_SIZE+1][i]= WALL;
      aiCollision[i][0]          = WALL;
      aiCollision[i][GRID_SIZE+1]= WALL;
   }

   // Inicializamos jugadores y objetos
   tShot.bActive= FALSE;
   for (i= 0; i< NUM_PLAYERS_SCREEN ; ++i) {
      atExplosion[i].iCurrFrame= 0;
      atExplosion[i].bActive= FALSE;
      patCurrentPlayer[i]->iX          = aiStartCoord[i][0];
      patCurrentPlayer[i]->iY          = aiStartCoord[i][1];
      patCurrentPlayer[i]->iDX         = 0;
      patCurrentPlayer[i]->iDY         = 0;
      patCurrentPlayer[i]->iMatchKills = 0;
      patCurrentPlayer[i]->iMatchDeads = 0;
      patCurrentPlayer[i]->iMatchPoints= 0;
      patCurrentPlayer[i]->iDirection  = i;
      patCurrentPlayer[i]->iNum        = i+1;
      patCurrentPlayer[i]->fAngle      = 64*(i+1);
      patCurrentPlayer[i]->iColor = makecol(aiColor[i][0], aiColor[i][1], aiColor[i][2]);
      iTank = (NUM_PLAYERS_SCREEN*((aiTemp[i]-1)/NUM_PLAYERS_SCREEN)+i) % NUM_TANK_IMAGES;
      patCurrentPlayer[i]->bmpTank= abmpTankImages[iTank];
      aiCollision[patCurrentPlayer[i]->iX][patCurrentPlayer[i]->iY]= i + 1;
   }

   // Cargamos el fondo
   tStage.bmpMap = load_png_from_dat(szMaps[tStage.iRound], BACKGROUND_FILE);
   tStage.sndSong= FSOUND_Stream_Open(szSongs[tStage.iRound], FSOUND_2D, 0, 0);
   tStage.iRound = (tStage.iRound + 1) % NUM_STAGES;   
}


// Quitamos de memoria los datos
void close_game_data(int iNumPlayers) {
   int i;
   int j;

   // Paramos el sonido y dejamos el volumen al maximo
   FSOUND_StopSound(FSOUND_ALL);
   FSOUND_SetVolume(FSOUND_ALL, 255);

   // Nos deshacemos de los bitmaps
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      for (j= 0; j< EXPLOSION_FRAMES; ++j) {
         destroy_bitmap(atExplosion[i].bmpSprite[j]);
      }
   }
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      destroy_bitmap(tStage.atSmallTank[i].bmpSprite[0]);
   }
   destroy_bitmap(tStage.bmpMap);
   destroy_bitmap(tStage.bmpBackground);
   destroy_bitmap(tShot.bmpSprite[0]);
   for (i= 0; i< NUM_TANK_IMAGES; ++i) {
      destroy_bitmap(abmpTankImages[i]);
   }
   
   // Nos deshacemos del arreglo que creamos
   safe_free(atPlayer);
}


// Ponemos las imagenes en pantalla
void update_screen(void) {
   int i;
   int iDX;
   int iDY;

   clear_clock();
   draw_sprite(g_bmpBuffer, tStage.bmpBackground, 0, 0);
   draw_sprite(g_bmpBuffer, tStage.bmpMap, MAP_X, MAP_Y);

   // Para cada jugador
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      // Ponemos el tanque en la vista aerea
      iDX= patCurrentPlayer[i]->iDX + MAP_X + TANK_DELTA_X;
      iDY= patCurrentPlayer[i]->iDY + MAP_Y + TANK_DELTA_Y;
      rotate_sprite(g_bmpBuffer, tStage.atSmallTank[i].bmpSprite[0], 
         CELL_SIZE*(patCurrentPlayer[i]->iX -1) + iDX,
         CELL_SIZE*(GRID_SIZE  -patCurrentPlayer[i]->iY) + iDY, ftofix(patCurrentPlayer[i]->fAngle));
      
      // Ponemos los datos del jugador
      textprintf_ex(g_bmpBuffer, font, DATA_TEXT_X, DATA_PLYR_DELTA_Y*i + DATA_TEXT_Y1,
         patCurrentPlayer[i]->iColor, -1, "%s", patCurrentPlayer[i]->szName);
      textprintf_ex(g_bmpBuffer, font, DATA_TEXT_X, DATA_PLYR_DELTA_Y*i + DATA_TEXT_Y2,
         patCurrentPlayer[i]->iColor, -1, "Favor:  %2d", patCurrentPlayer[i]->iMatchKills);
      textprintf_ex(g_bmpBuffer, font, DATA_TEXT_X, DATA_PLYR_DELTA_Y*i + DATA_TEXT_Y3,
         patCurrentPlayer[i]->iColor, -1, "Contra: %2d", patCurrentPlayer[i]->iMatchDeads);
      draw_sprite(g_bmpBuffer, patCurrentPlayer[i]->bmpTank, DATA_TANK_X, DATA_PLYR_DELTA_Y*i + MAP_Y);
   }

   // Revisamos explosiones
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      if (atExplosion[i].bActive) {
         draw_sprite(g_bmpBuffer, atExplosion[i].bmpSprite[atExplosion[i].iCurrFrame],
            atExplosion[i].iX, atExplosion[i].iY);
         ++atExplosion[i].iCurrFrame;
         if (atExplosion[i].iCurrFrame >= EXPLOSION_FRAMES) {
            atExplosion[i].iCurrFrame= 0;
            atExplosion[i].bActive= FALSE;
         }
      }
   }

   if (tShot.bActive) {
      draw_sprite(g_bmpBuffer, tShot.bmpSprite[0], CELL_SIZE*(tShot.iX-1) + MAP_X + SHOT_DELTA_X1,
         CELL_SIZE*(GRID_SIZE -tShot.iY) + MAP_Y + SHOT_DELTA_Y1);
      draw_sprite(g_bmpBuffer, tShot.bmpSprite[0], CELL_SIZE*(tShot.iX-1) + MAP_X + SHOT_DELTA_X2, 
         CELL_SIZE*(GRID_SIZE -tShot.iY) + MAP_Y + SHOT_DELTA_Y1);
      draw_sprite(g_bmpBuffer, tShot.bmpSprite[0], CELL_SIZE*(tShot.iX-1) + MAP_X + SHOT_DELTA_X1,
         CELL_SIZE*(GRID_SIZE -tShot.iY) + MAP_Y + SHOT_DELTA_Y2);
      draw_sprite(g_bmpBuffer, tShot.bmpSprite[0], CELL_SIZE*(tShot.iX-1) + MAP_X + SHOT_DELTA_X2, 
         CELL_SIZE*(GRID_SIZE -tShot.iY) + MAP_Y + SHOT_DELTA_Y2);
   }

   // Pasamos todo a pantalla
   draw_sprite(screen, g_bmpBuffer, 0, 0);
   wait_clock(iTimePerTurn, TRUE);
}


// Actualiza al tanque de acuerdo a la opcion que eligi
void update_actions(stPlayerData *pPlayer, char cAction) {
   int i;
   int iTemp;
   int iNewX;
   int iNewY;
   int iCurrCell;
   int iX= pPlayer->iX;
   int iY= pPlayer->iY;
   int iDX= aiMovement[pPlayer->iDirection][0];
   int iDY= aiMovement[pPlayer->iDirection][1];
   stPlayerData *pPlayerKilled;

   // Revisamos que accion se efectuo
   switch (cAction) {
      case 'A':      // En caso de que avanzen
         if (aiCollision[iX + iDX][iY + iDY] == EMPTY) {
            aiCollision[iX][iY]= EMPTY;
            iX+= iDX;
            iY+= iDY;
            aiCollision[iX][iY]= pPlayer->iNum;
            for (i= 1; i<= FRAMES_PER_ANIM ; ++i) {
               pPlayer->iDX+= POS_DELTA *iDX;
               pPlayer->iDY-= POS_DELTA *iDY;
               update_screen();
            }
            pPlayer->iDX= 0;
            pPlayer->iDY= 0;
         }
         break;
      case 'R':      // En caso de que retrocedan
         if (aiCollision[iX -iDX][iY -iDY] == EMPTY) {
            aiCollision[iX][iY]= EMPTY;
            iX-= iDX;
            iY-= iDY;
            aiCollision[iX][iY]= pPlayer->iNum;
            for (i= 1; i<= FRAMES_PER_ANIM ; ++i) {
               pPlayer->iDX-= POS_DELTA *iDX;
               pPlayer->iDY+= POS_DELTA *iDY;
               update_screen();
            }
            pPlayer->iDX= 0;
            pPlayer->iDY= 0;
         }
         break;
      case 'I':      // En caso de que giren a la izquierda
         pPlayer->iDirection= (NUM_DIR + pPlayer->iDirection -1) % NUM_DIR;
         for (i= 1; i<= FRAMES_PER_ANIM; ++i) {
            pPlayer->fAngle-= ANGLE_DELTA ;
            update_screen();
         }
         break;
      case 'D':      // En caso de que giren a la derecha
         pPlayer->iDirection= (pPlayer->iDirection + 1) % NUM_DIR;
         for (i= 1; i<= FRAMES_PER_ANIM; ++i) {
            pPlayer->fAngle+= ANGLE_DELTA ;
            update_screen();
         }
         break;
      case 'S':      // En caso de que disparen
         tShot.bActive= TRUE;
         FSOUND_PlaySound(FSOUND_FREE, sndShot);
         for (i= 1; i<= FRAMES_PER_ANIM ; ++i) {
            iCurrCell = aiCollision[iX + i*iDX][iY + i*iDY];
            if (iCurrCell == WALL) {
               break;
            }
            tShot.iX= (iX + i*iDX);
            tShot.iY= (iY + i*iDY);
            if (iCurrCell != EMPTY) {
               FSOUND_PlaySound(FSOUND_FREE, sndBomb);
               atExplosion[iCurrCell -1].bActive= TRUE;
               atExplosion[iCurrCell -1].iX= 
                  CELL_SIZE*(tShot.iX -1) + MAP_X + EXPL_DELTA_X;
               atExplosion[iCurrCell -1].iY= 
                  CELL_SIZE*(GRID_SIZE -tShot.iY) + MAP_Y + EXPL_DELTA_Y ;
               pPlayer->iMatchKills++;
               scanf("%d %d %d\n", &iTemp, &iNewX, &iNewY);
               pPlayerKilled= patCurrentPlayer[iTemp];
               pPlayerKilled->iMatchDeads++;
               aiCollision[pPlayerKilled->iX][pPlayerKilled->iY]= EMPTY;
               pPlayerKilled->iX= iNewX;
               pPlayerKilled->iY= iNewY;
               aiCollision[pPlayerKilled->iX][pPlayerKilled->iY]= iTemp + 1;
            }
         update_screen();
         }
         scanf("%d\n", &iTemp);

         tShot.bActive= FALSE;
         for ( ; i<= FRAMES_PER_ANIM; ++i) {
            update_screen();
         }
         break;
   }
   pPlayer->iX= iX;
   pPlayer->iY= iY;
}


// Secuencia principal del juego
void tanks_battle(void) {
   char cAction;
   int i;
   int iTurn;
   int iTotalTurns;
   int iNumPlayers;
   int iGamesPerPlayer;
   int iCurrentPlayer;

   // Inicializamos
   
   if (freopen(BATTLE_FILE, "rt", stdin) != NULL) {
      scanf("%d %d %d %d\n", &iNumPlayers, &iGamesPerPlayer, &iTotalTurns, &iTimePerTurn);
      init_game_data(iNumPlayers);
      freopen(BATTLE_FILE, "rt", stdin);
      scanf("%*[^\n]");
   } else {
      error_message("Error al abrir el archivo de jugadas: No se encontro el archivo.");
   }

   // Corremos todos los rounds
   for (i= 0; i< iGamesPerPlayer*(iNumPlayers/NUM_PLAYERS_SCREEN); ++i) {
      // Inicializamos el round
      init_battle(iNumPlayers);
      vs_screen();
      FSOUND_Stream_Play(FSOUND_FREE, tStage.sndSong);
      FSOUND_Stream_SetMode(tStage.sndSong, FSOUND_LOOP_NORMAL);
      fade_music_in(500);

      // Corremos todos los turnos para cada jugador
      for (iTurn= 0; iTurn< iTotalTurns; ++iTurn) {
         for (iCurrentPlayer= 0; iCurrentPlayer< NUM_PLAYERS_SCREEN; ++iCurrentPlayer) {
            scanf("%c\n", &cAction);
            update_actions(patCurrentPlayer[iCurrentPlayer], cAction);
            update_screen();
         }
      }

      // Terminaos el round
      fade_music_out(500);
      FSOUND_Stream_Close(tStage.sndSong);
      score_screen();
   }

   winners_sequence(iNumPlayers);
   close_game_data(iNumPlayers);
}
