/***********************************************************
 *                                                         *
 *  intro.c                                                *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Secuencia de intro de los tanques.           *
 *                                                         *
 ***********************************************************/

// Librerias a incluir
#include "intro.h"
#include "time.h"
#include "config.h"
#include "fade.h"
#include "grabber.h"
#include "constants.h"
#include <allegro.h>
#include <fmod.h>


// Variables del archivo
static BITMAP *bmpACM;
static BITMAP *bmpBona;
static BITMAP *bmpMainScreen;
static BITMAP *bmpMap;
static BITMAP *bmpTank;
static BITMAP *bmpBackground[2];
static BITMAP *bmpText[4];
static FSOUND_STREAM *sndIntro;
extern BITMAP *g_bmpBuffer;


// Cargamos e inicializamos datos del intro
void init_intro(void) {
   // Cargamos Sonido
   sndIntro = FSOUND_Stream_Open(INTRO_SONG, FSOUND_2D, 0, 0);

   // Cargamos Imagenes
   bmpACM          = load_png_from_dat("ACM", INTRO_FILE);
   bmpBona         = load_png_from_dat("BONA", INTRO_FILE);
   bmpMap          = load_png_from_dat("MAP", INTRO_FILE);
   bmpTank         = load_png_from_dat("TANk", INTRO_FILE);
   bmpMainScreen   = load_png_from_dat("MAIN_SCREEN", INTRO_FILE);
   bmpText[0]      = load_png_from_dat("TEXT1", INTRO_FILE);
   bmpText[1]      = load_png_from_dat("TEXT2", INTRO_FILE);
   bmpText[2]      = load_png_from_dat("TEXT3", INTRO_FILE);
   bmpText[3]      = load_png_from_dat("TEXT4", INTRO_FILE);
   bmpBackground[0]= load_png_from_dat("BACKGROUND1", INTRO_FILE);
   bmpBackground[1]= load_png_from_dat("BACKGROUND2", INTRO_FILE);

   // Ponemos el fondo a negro
   clear_to_color(g_bmpBuffer, makecol(0,0,0));
}


// Cerramos datos
void close_intro(void) {
   int i;

   FSOUND_Stream_Close(sndIntro);
   FSOUND_SetVolume(FSOUND_ALL, 255);
   for (i= 0; i< 4; ++i) {
      destroy_bitmap(bmpText[i]);
   }
   for (i= 0; i< 2; ++i) {
      destroy_bitmap(bmpBackground[i]);
   }
   destroy_bitmap(bmpACM);
   destroy_bitmap(bmpBona);
   destroy_bitmap(bmpTank);
   destroy_bitmap(bmpMap);
   destroy_bitmap(bmpMainScreen);
}


// Secuencia del intro
void intro(void) {
   int i;
   int iTime;
   int iStartTime;
   int iLength;
   int iWidth;
   const int iPosX[4] = {7, 4, 0, 3};
   const int iPosY[4] = {0, 3, 2, 0};

   // Inicializamos y ponemos la musica
   init_intro();
   clear_clock();
   FSOUND_Stream_Play(FSOUND_FREE, sndIntro);
   fade_music_in(1000);

   // Secuencia de logos
   wait_clock(2000, FALSE);
   fade_from_color(bmpBona, 1000, (SCREEN_WIDTH -bmpBona->w)/2, (SCREEN_HEIGHT -bmpBona->h)/2, makecol(0,0,0));
   wait_clock(5500, FALSE);
   fade_to_color(bmpBona, 1000, (SCREEN_WIDTH -bmpBona->w)/2, (SCREEN_HEIGHT -bmpBona->h)/2, makecol(0,0,0));
   wait_clock(7500, FALSE);
   fade_from_color(bmpACM, 1000, (SCREEN_WIDTH -bmpACM->w)/2 , (SCREEN_HEIGHT -bmpACM->h)/2 , makecol(0,0,0));
   wait_clock(11000, FALSE);
   fade_to_color  (bmpACM , 1000, (SCREEN_WIDTH -bmpACM->w)/2 , (SCREEN_HEIGHT -bmpACM->h)/2 , makecol(0,0,0));
   wait_clock(15000, FALSE);
   
   // Secuencia "No es solo estrategia"
   fade_from_color(bmpText[0], 500, (SCREEN_WIDTH -bmpText[0]->w)/2, 90, makecol(0,0,0));
   wait_clock(16600, FALSE);
   draw_sprite(screen, bmpText[1], 200, 270);
   wait_clock(17600, FALSE);
   draw_sprite(screen, bmpText[2], 400, 325);
   wait_clock(18600, FALSE);

   // Secuencia "Guerra" con ruido de fondo
   while (return_clock() < 21000) {
      iTime= return_clock();
      draw_sprite(g_bmpBuffer, bmpBackground[(iTime % 500 > 50) ? (0) : (1)], 
         iPosX[(iTime/300)%4], iPosY[(iTime/300)%4]);
      draw_sprite(g_bmpBuffer, bmpText[3], (SCREEN_WIDTH -bmpText[3]->w)/2, (SCREEN_HEIGHT -bmpText[3]->h)/2);
      draw_sprite(screen, g_bmpBuffer, 0, 0);
   }
   clear_to_color(g_bmpBuffer, makecol(0,0,0));
   draw_sprite(screen, g_bmpBuffer, 0, 0);

   // Secuencia del tanque con ruido de fondo
   fade_from_color(bmpTank, 250, (SCREEN_WIDTH -bmpTank->w)/2, (SCREEN_HEIGHT -bmpTank->h)/2, makecol(0,0,0));
   while (return_clock() < 23400) {
      iTime= return_clock();
      draw_sprite(g_bmpBuffer, bmpBackground[(iTime % 500 > 50) ? (0) : (1)], 
         iPosX[(iTime/300)%4], iPosY[(iTime/300)%4]);
      draw_sprite(g_bmpBuffer, bmpTank, (SCREEN_WIDTH -bmpTank->w)/2, (SCREEN_HEIGHT -bmpTank->h)/2);
      draw_sprite(screen, g_bmpBuffer, 0, 0);
   }
   fade_to_color(bmpTank, 250, (SCREEN_WIDTH -bmpTank->w)/2, (SCREEN_HEIGHT -bmpTank->h)/2, makecol(0,0,0));

   // Secuencia de zoom a las letras de "Guerra"
   iStartTime= return_clock();
   while (return_clock() < 29000) {
      iTime= return_clock();
      clear_to_color(g_bmpBuffer, makecol(0,0,0));
      // Ponemos el fondo del mundo solo cuando suena
      if ((25400 < iTime) && (iTime < 25500)) {
         draw_sprite(g_bmpBuffer, bmpMap, (SCREEN_WIDTH -bmpMap->w)/2, (SCREEN_HEIGHT -bmpMap->h)/2);
      }
      // Crecemos el texto a 15 veces su tamao original
      iWidth= (15*bmpText[3]->w)*(iTime-iStartTime)/28000;
      iLength= (15*bmpText[3]->h)*(iTime-iStartTime)/28000;
      stretch_sprite(g_bmpBuffer, bmpText[3], (SCREEN_WIDTH -iWidth)/2, 
         (SCREEN_HEIGHT -iLength)/2, iWidth, iLength);
      draw_sprite(screen, g_bmpBuffer, 0, 0);
   }

   // Ponemos la pantalla principal
   fade_from_color(bmpMainScreen, 1000, (SCREEN_WIDTH -bmpMainScreen->w)/2, (SCREEN_HEIGHT-bmpMainScreen->h)/2, makecol(0,0,0));
   wait_clock(40000, FALSE);
   fade_media_out(bmpMainScreen, 1000, 0, 0, makecol(0,0,0));

   close_intro(); 
}
