/***********************************************************
 *                                                         *
 *  grabber.h                                              *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Headers para las funciones del grabber.      *
 *                                                         *
 ***********************************************************/

#ifndef F_GRABBER_H
#define F_GRABBER_H

// Incluimos librerias
#include <alfont.h>
#include <allegro.h>
#include <fmod.h>

//
#define DAT_PNG  DAT_ID('P','N','G',' ')

// Definimos funciones
void register_datafile_objects(void);                    // Registramos las extensiones que vayamos a utilizat en los datafile
ALFONT_FONT *load_font_from_dat(const char *, const char *, int);    // Para cargar un font ttf con alfont desde un dat de grabber
BITMAP *load_bmp_from_dat(const char *, const char *);               // Para cargar una imagen bmp desde un dat de grabber
BITMAP *load_png_from_dat(const char *, const char *);               // Para cargar una imagen png desde un dat de grabber
RLE_SPRITE *load_rle_from_dat(const char *, const char *);           // Para cargar una imagen rle desde un dat de grabber
char *load_txt_from_dat(const char *, const char *, int *);          // Para carga un archivo de texto desde un dat de grabber
FSOUND_SAMPLE *load_sound_from_dat(const char *, const char *);      // Para carga un archivo de sonido desde un .dat de grabber
FSOUND_STREAM *load_stream_from_dat(const char *, const char *);     // Para carga un archivo de musica como stream desde un .dat de grabber

#endif
