/***********************************************************
 *                                                         *
 *  ending.h                                               *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Header de las funciones de los creditos.     *
 *                                                         *
 ***********************************************************/
 
 
 // Incluimos librerias
#include "ending.h"
#include "fade.h"
#include "time.h"
#include "config.h"
#include "constants.h"
#include "grabber.h"
#include <allegro.h>
#include <fmod.h>


// Declaramos variables
static BITMAP *bmpThanks;
static BITMAP *bmpCredits[7];
static FSOUND_STREAM *sndEnding;


// Cargamos las imagenes y la musica
void init_ending(void) {
   sndEnding    = FSOUND_Stream_Open(ENDING_SONG, FSOUND_2D, 0, 0);
   bmpThanks    = load_png_from_dat("THANKS", ENDING_FILE);
   bmpCredits[0]= load_png_from_dat("CREDITS", ENDING_FILE);
   bmpCredits[1]= load_png_from_dat("ORGANIZATION", ENDING_FILE);
   bmpCredits[2]= load_png_from_dat("DAVALOS", ENDING_FILE);
   bmpCredits[3]= load_png_from_dat("PROGRAMMING", ENDING_FILE);
   bmpCredits[4]= load_png_from_dat("PIER", ENDING_FILE);
   bmpCredits[5]= load_png_from_dat("MULTIMEDIA", ENDING_FILE);
   bmpCredits[6]= load_png_from_dat("OSCAR", ENDING_FILE);
}


// Destruimos imagenes y cerramos musica
void close_ending(void) {
   int i;

   FSOUND_Stream_Close(sndEnding);
   for (i= 0; i< 7; i++) {
      destroy_bitmap(bmpCredits[i]);
   }
   destroy_bitmap(bmpThanks);
}


// Secuencia de creditos
void ending(void) {
   int i;

   init_ending();
   FSOUND_Stream_Play(FSOUND_FREE, sndEnding);
   fade_music_in(1000);
   clear_clock();
   clear(screen);
   wait_clock(1500, TRUE);
   for (i= 0; i< 7; ++i) {
      fade_from_color(bmpCredits[i], 1000, (SCREEN_WIDTH -bmpCredits[i]->w)/2, (SCREEN_HEIGHT -bmpCredits[i]->h)/2, makecol(0,0,0));
      wait_clock(2250, TRUE);
      fade_to_color(bmpCredits[i], 1000, (SCREEN_WIDTH -bmpCredits[i]->w)/2, (SCREEN_HEIGHT -bmpCredits[i]->h)/2, makecol(0,0,0));
      wait_clock(1250, TRUE);
   }
   fade_from_color(bmpThanks, 1000, 0, 0, makecol(0,0,0));
   clear_keybuf();
   readkey();
   fade_media_out(bmpThanks, 1000, 0, 0, makecol(0,0,0));
   close_ending();
}
