/***********************************************************
 *                                                         *
 *  constants.h                                            *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Headers con las constantes principales.      *
 *                                                         *
 ***********************************************************/

#ifndef CONSTANTS_H
#define CONSTANTS_H

// Constantes por macro
#define STRING_SIZE           256      // Tamao de las cadenas
#define SCREEN_WIDTH          800      // Pixeles a lo ancho
#define SCREEN_HEIGHT         600      // Pixeles a lo largo
#define MIX_RATE            44100      // Frecuencia a la que van las canciones
#define CHANNELS               32      // Cantidad de canales de sonido
#define MUSIC_FLAGS             0      // Banderas usadas al inicializar FMOD

#define NUM_PLAYERS_SCREEN      4      // Jugadores en pantalla al mismo tiempo
#define NUM_TANK_IMAGES        16      // Cantidad de imagenes de tanques distintas (tanques visto de lado)
#define NUM_INSTRUCTIONS        6      // Cantidad de instrucciones distintas
#define NUM_DIR                 4      // Canridad de direcciones (N, S, E, O)
#define GRID_SIZE               7      // Tamao de la cuadricula (en cuadros)
#define CELL_SIZE              80      // Tamao de cada cuadro (en pixeles)
#define FRAMES_PER_ANIM         5      // Numero de frames por cada animacion (tiene que ser 5 porque es el alance de una bala)
#define POS_DELTA              16      // Cuanto avanza en cada frame (= CELL_SIZE/FRAMES_PER_ANIM)
#define ANGLE_DELTA            12.8    // Cuantos grados gira en cada frame (= 64/FRAMES_PER_ANIM)
#define NUM_STAGES              8      // Numero de escenas
#define MAX_SPRITES            10      // Numero maximo de sprites en una animacion
#define EXPLOSION_FRAMES       10      // Frames que tiene una explosion
#define EXPL_DELTA_X             5     // Defasamiento de las explosines en x
#define EXPL_DELTA_Y           -15     // Defasamiento de las explosines en y
#define TANK_DELTA_X           15      // Defasamiento de los tanques en x
#define TANK_DELTA_Y            5      // Defasamiento de los tanques en y
#define SHOT_DELTA_X1          20      // Defasamiento de los disparos en x
#define SHOT_DELTA_Y1          20      // Defasamiento de los disparos en y
#define SHOT_DELTA_X2          52      // Defasamiento de los disparos en x
#define SHOT_DELTA_Y2          50      // Defasamiento de los disparos en y
#define NUM_COLORS              6      // Los cuatro colores de los tanques, mas gris y negro
#define WALL                   -1      // Pared (para detectar colisiones)
#define EMPTY                   0      // Vacio (para detectar colisiones)
#define MAP_X                 220      // Posicion en x del mapa
#define MAP_Y                  20      // Posicion en y del mapa
#define DATA_TANK_X            17      // Posicion en x del tanque de los datos
#define DATA_TEXT_X           110      // Posicion en x de los textos de los jugadores
#define DATA_PLYR_DELTA_Y      98      // Separacion en y entre datos de jugadores
#define DATA_TEXT_Y1           30      // Posicion en y del primer texto de los jugadores
#define DATA_TEXT_Y2           50      // Posicion en y del segundo texto de los jugadores
#define DATA_TEXT_Y3           70      // Posicion en y del tecer texto de los jugadores

#endif
